/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AENot;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.bool.ETAnd;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.bool.ETComparison;
import com.amazon.sqlengine.executor.etree.bool.ETLike;
import com.amazon.sqlengine.executor.etree.bool.ETNot;
import com.amazon.sqlengine.executor.etree.bool.ETNullPredicate;
import com.amazon.sqlengine.executor.etree.bool.ETOr;
import com.amazon.sqlengine.executor.etree.bool.ETTrue;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.BooleanFunctorFactory;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.IBooleanCompFunctor;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.amazon.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.amazon.sqlengine.executor.materializer.MaterializerBase;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.sqlengine.executor.queryplan.IQueryPlan;
import com.amazon.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETBoolExprMaterializer
extends MaterializerBase<ETBooleanExpr> {
    public ETBoolExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETBooleanExpr visit(AEAnd aEAnd) throws ErrorException {
        return new ETAnd(aEAnd.getLeftOperand().acceptVisitor(this), aEAnd.getRightOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AEOr aEOr) throws ErrorException {
        return new ETOr(aEOr.getLeftOperand().acceptVisitor(this), aEOr.getRightOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AENot aENot) throws ErrorException {
        return new ETNot(aENot.getOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AEComparison aEComparison) throws ErrorException {
        if (aEComparison.getLeftOperand().getNumChildren() != 1 || aEComparison.getRightOperand().getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Compare value list");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)aEComparison.getLeftOperand().getChild(0);
        AEValueExpr aEValueExpr2 = (AEValueExpr)aEComparison.getRightOperand().getChild(0);
        IColumn iColumn = aEComparison.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = this.materializeExpr(aEValueExpr, iColumn);
        ETValueExpr eTValueExpr2 = this.materializeExpr(aEValueExpr2, iColumn);
        IBooleanCompFunctor iBooleanCompFunctor = BooleanFunctorFactory.getBoolCompFunctor(aEComparison.getComparisonOp(), iColumn.getTypeMetadata());
        return new ETComparison(iColumn, eTValueExpr, eTValueExpr2, iBooleanCompFunctor);
    }

    @Override
    public ETBooleanExpr visit(AELikePredicate aELikePredicate) throws ErrorException {
        AEValueExpr aEValueExpr = aELikePredicate.getEscapeChar();
        AEValueExpr aEValueExpr2 = aELikePredicate.getLeftOperand();
        AEValueExpr aEValueExpr3 = aELikePredicate.getRightOperand();
        IColumn iColumn = aELikePredicate.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = null;
        if (aEValueExpr != null) {
            eTValueExpr = this.materializeExpr(aEValueExpr, iColumn);
        }
        ETValueExpr eTValueExpr2 = this.materializeExpr(aEValueExpr2, iColumn);
        ETValueExpr eTValueExpr3 = this.materializeExpr(aEValueExpr3, iColumn);
        return new ETLike(iColumn, eTValueExpr2, eTValueExpr3, eTValueExpr);
    }

    @Override
    public ETBooleanExpr visit(AEInPredicate aEInPredicate) throws ErrorException {
        Object object;
        Object object2;
        AEValueExprList aEValueExprList = aEInPredicate.getLeftOperand();
        if (aEValueExprList.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("IN predicate with multiple columns on as left operand.");
        }
        IColumn iColumn = aEInPredicate.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = this.materializeExpr((AEValueExpr)aEValueExprList.getChild(0), iColumn);
        IAENode iAENode = aEInPredicate.getRightOperand();
        if (iAENode instanceof AERelationalExpr) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Subquery in IN clause");
        }
        if (!(iAENode instanceof AEValueExprList)) {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        LinkedList<ETComparison> linkedList = new LinkedList<ETComparison>();
        Iterator iterator = ((AEValueExprList)iAENode).getChildItr();
        while (iterator.hasNext()) {
            object2 = this.materializeExpr((AEValueExpr)iterator.next(), iColumn);
            object = BooleanFunctorFactory.getBoolCompFunctor(AEComparisonType.EQUAL, iColumn.getTypeMetadata());
            linkedList.add(new ETComparison(iColumn, eTValueExpr, (ETValueExpr)object2, (IBooleanCompFunctor)object));
        }
        if (linkedList.size() == 0) {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        object2 = linkedList.iterator();
        object = (ETBooleanExpr)object2.next();
        while (object2.hasNext()) {
            object = new ETOr((ETBooleanExpr)object, (ETBooleanExpr)object2.next());
        }
        return object;
    }

    @Override
    public ETBooleanExpr visit(AENullPredicate aENullPredicate) throws ErrorException {
        AEValueExprList aEValueExprList = aENullPredicate.getOperand();
        if (aEValueExprList.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("IS NULL predicate on multiple column.");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(0);
        ETValueExpr eTValueExpr = this.materializeExpr(aEValueExpr, null);
        return new ETNullPredicate(eTValueExpr, aEValueExpr.getColumn());
    }

    @Override
    public ETBooleanExpr visit(AEBooleanTrue aEBooleanTrue) throws ErrorException {
        return new ETTrue();
    }

    @Override
    public ETBooleanExpr visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("EXIST");
    }

    @Override
    public ETBooleanExpr visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("QUANTIFIED COMPARISON");
    }

    private ETValueExpr materializeExpr(AEValueExpr aEValueExpr, IColumn iColumn) throws ErrorException {
        ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(eTValueExprMaterializer);
        if (iColumn == null) {
            return eTValueExpr;
        }
        return ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aEValueExpr.getColumn(), iColumn, this.getContext());
    }

    protected ETValueExprMaterializer createValueExprMaterializer() {
        return new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
    }
}

