/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.aggregatefn;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.util.CompressionUtil;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregator;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CountAggregatorFactory
extends AbstractAggregatorFactory {
    private final boolean m_isCountStar;
    private final boolean m_isDistinct;

    public CountAggregatorFactory(IColumn[] iColumnArray, IColumn iColumn, boolean bl) {
        super(iColumnArray, iColumn);
        if (bl) {
            throw new UnsupportedOperationException("DISTINCT");
        }
        this.m_isCountStar = 0 == iColumnArray.length;
        this.m_isDistinct = bl;
    }

    public boolean requiresDistinct() {
        return !this.m_isCountStar && this.m_isDistinct;
    }

    public CountAggregator createAggregator() {
        return this.m_isCountStar ? new CountStarAggregator(this) : new CountAggregator(this);
    }

    private static final class CountStarAggregator
    extends CountAggregator {
        public CountStarAggregator(CountAggregatorFactory countAggregatorFactory) {
            super(countAggregatorFactory);
        }

        protected boolean shouldUpdate() throws ErrorException {
            return true;
        }
    }

    private static class CountAggregator
    extends AbstractAggregator {
        private long m_count = 0L;

        public CountAggregator(CountAggregatorFactory countAggregatorFactory) {
            super(countAggregatorFactory);
        }

        public void load(byte[] byArray) throws ErrorException {
            try {
                this.m_count = ByteBuffer.wrap(byArray).getLong();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        public byte[] serialize() {
            return ByteBuffer.allocate(8).putLong(this.m_count).array();
        }

        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            eTDataRequest.getData().setBigInt(CompressionUtil.getlongAsBigInteger(this.m_count, false));
            return false;
        }

        protected void update() throws ErrorException {
            if (this.shouldUpdate()) {
                ++this.m_count;
            }
        }

        protected boolean shouldUpdate() throws ErrorException {
            return !this.getArgumentData(0, 0L, 0L).isNull();
        }

        protected long getMemoryUsage() {
            return 8L;
        }

        public void reset() {
            this.m_count = 0L;
        }

        public void close() {
        }
    }
}

