/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public final class FunctionParameterWrapper
implements ISqlDataWrapper {
    private final ETValueExpr m_valueExpr;
    private final IColumn m_columnMetadata;
    private ETDataRequest m_dataRequest = null;

    FunctionParameterWrapper(ETValueExpr eTValueExpr, IColumn iColumn) {
        if (null == eTValueExpr || null == iColumn) {
            throw new NullPointerException();
        }
        if (!eTValueExpr.isOpen()) {
            throw new IllegalArgumentException("valueExpr is not open.");
        }
        this.m_valueExpr = eTValueExpr;
        this.m_columnMetadata = iColumn;
    }

    public BigInteger getBigInt() throws ErrorException {
        return this.retrieveData().getBigInt();
    }

    public byte[] getBinary() throws ErrorException {
        return this.retrieveData().getBinary();
    }

    public boolean getBoolean() throws ErrorException, NullPointerException {
        return this.retrieveData().getBoolean();
    }

    public String getChar() throws ErrorException {
        return this.retrieveData().getChar();
    }

    public Date getDate() throws ErrorException {
        return this.retrieveData().getDate();
    }

    public BigDecimal getExactNumber() throws ErrorException {
        return this.retrieveData().getExactNumber();
    }

    public double getDouble() throws ErrorException, NullPointerException {
        return this.retrieveData().getDouble();
    }

    public UUID getGuid() throws ErrorException {
        return this.retrieveData().getGuid();
    }

    public long getInteger() throws ErrorException, NullPointerException {
        return this.retrieveData().getInteger();
    }

    public Object getInterval() throws ErrorException {
        return this.retrieveData().getInterval();
    }

    public float getReal() throws ErrorException, NullPointerException {
        return this.retrieveData().getReal();
    }

    public int getSmallInt() throws ErrorException, NullPointerException {
        return this.retrieveData().getSmallInt();
    }

    public Time getTime() throws ErrorException {
        return this.retrieveData().getTime();
    }

    public Timestamp getTimestamp() throws ErrorException {
        return this.retrieveData().getTimestamp();
    }

    public short getTinyInt() throws ErrorException, NullPointerException {
        return this.retrieveData().getTinyInt();
    }

    public int getType() {
        return this.m_columnMetadata.getTypeMetadata().getType();
    }

    public boolean isNull() throws ErrorException {
        return this.retrieveData().isNull();
    }

    public boolean isSet() {
        return null != this.m_dataRequest;
    }

    public void retrieveData(DataWrapper dataWrapper) {
        throw new UnsupportedOperationException();
    }

    public void setBigInt(BigInteger bigInteger) {
        throw new UnsupportedOperationException();
    }

    public void setBinary(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setChar(String string) {
        throw new UnsupportedOperationException();
    }

    public void setDate(Date date) {
        throw new UnsupportedOperationException();
    }

    public void setDouble(double d) {
        throw new UnsupportedOperationException();
    }

    public void setExactNumber(BigDecimal bigDecimal) {
        throw new UnsupportedOperationException();
    }

    public void setGuid(UUID uUID) {
        throw new UnsupportedOperationException();
    }

    public void setInteger(long l) {
        throw new UnsupportedOperationException();
    }

    public void setInterval(Object object) {
        throw new UnsupportedOperationException();
    }

    public void setNull() {
        throw new UnsupportedOperationException();
    }

    public void setReal(float f) {
        throw new UnsupportedOperationException();
    }

    public void setSmallInt(int n) {
        throw new UnsupportedOperationException();
    }

    public void setTime(Time time) {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(Timestamp timestamp) {
        throw new UnsupportedOperationException();
    }

    public void setTinyInt(short s) {
        throw new UnsupportedOperationException();
    }

    public void setValue(DataWrapper dataWrapper) {
        throw new UnsupportedOperationException();
    }

    private ISqlDataWrapper retrieveData() throws ErrorException {
        ETValueExpr eTValueExpr = this.m_valueExpr;
        assert (eTValueExpr.isOpen()) : "m_valueExpr was not open.";
        ETDataRequest eTDataRequest = this.m_dataRequest;
        if (null == eTDataRequest && !eTValueExpr.retrieveData(eTDataRequest = (this.m_dataRequest = new ETDataRequest(this.m_columnMetadata)))) {
            throw new IllegalStateException();
        }
        return eTDataRequest.getData();
    }
}

