/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETAggregateFn
extends ETValueExpr {
    private AEAggrFn.AggrFnId m_functionId;
    private IAggregator m_aggregator;
    private final ETValueUpdateParameters m_updateParameters;
    private ETValueExprList m_operands;
    private boolean m_isOpen = false;

    public ETAggregateFn(AEAggrFn.AggrFnId aggrFnId, ETValueExprList eTValueExprList, List<? extends IColumn> list, IAggregator iAggregator) {
        this.m_functionId = aggrFnId;
        this.m_aggregator = iAggregator;
        this.m_updateParameters = new ETValueUpdateParameters(eTValueExprList, list.toArray(new IColumn[0]));
        this.m_operands = eTValueExprList;
    }

    @Override
    public void close() {
        this.m_operands.close();
        this.m_isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() {
        this.m_operands.reset();
        this.m_aggregator.reset();
    }

    @Override
    public String getLogString() {
        return "ETAggregateFn: " + (Object)((Object)this.m_functionId);
    }

    @Override
    public void update() throws ErrorException {
        this.m_aggregator.update(this.m_updateParameters);
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return this.m_operands.getNumChildren();
    }

    @Override
    public void open() {
        this.m_operands.open();
        this.m_aggregator.reset();
        this.m_isOpen = false;
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_aggregator.retrieveData(eTDataRequest);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        super.registerWarningListener(iWarningListener);
        this.m_aggregator.registerWarningListener(iWarningListener);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        return this.m_operands.getChild(n);
    }

    private static class ETValueUpdateParameters
    implements IAggregator.IUpdateParameters {
        private boolean[] m_hasMoreData;
        private ETDataRequest[] m_dataRequest;
        private ETValueExprList m_valueExprs;
        private IColumn[] m_inputMetadata;

        public ETValueUpdateParameters(ETValueExprList eTValueExprList, IColumn[] iColumnArray) {
            this.m_valueExprs = eTValueExprList;
            this.m_inputMetadata = iColumnArray;
            this.m_dataRequest = new ETDataRequest[iColumnArray.length];
            for (int i = 0; i < iColumnArray.length; ++i) {
                this.m_dataRequest[i] = new ETDataRequest(iColumnArray[i]);
            }
            this.m_hasMoreData = new boolean[iColumnArray.length];
        }

        public ISqlDataWrapper getData(int n) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(0L);
            eTDataRequest.setMaxBytes(-1L);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueExprs.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        public ISqlDataWrapper getData(int n, long l, long l2) throws ErrorException {
            ETDataRequest eTDataRequest = this.m_dataRequest[n];
            eTDataRequest.setOffset(l);
            eTDataRequest.setMaxBytes(l2);
            eTDataRequest.getData().setNull();
            this.m_hasMoreData[n] = this.m_valueExprs.retrieveData(n, eTDataRequest);
            return eTDataRequest.getData();
        }

        public IColumn getMetadata(int n) {
            return this.m_inputMetadata[n];
        }

        public boolean hasMoreData(int n) {
            return this.m_hasMoreData[n];
        }
    }
}

