/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation.join;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.executor.etree.ETBoolean;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.bool.ETComparison;
import com.amazon.sqlengine.executor.etree.bool.functor.comp.BooleanFunctorFactory;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.join.ETJoinedUnitWrapper;
import com.amazon.sqlengine.executor.etree.relation.join.IJoinAlgorithmAdapter;
import com.amazon.sqlengine.executor.etree.relation.join.IJoinUnit;
import com.amazon.sqlengine.executor.etree.relation.join.NBJoinAlgorithm;
import com.amazon.sqlengine.executor.etree.value.ETColumnRef;
import com.amazon.sqlengine.utilities.ExternalAlgorithmUtil;
import com.amazon.support.IWarningListener;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NBFallBackJoinAlgorithm
implements IJoinAlgorithmAdapter {
    private IJoinAlgorithmAdapter m_fallBack;
    private ETJoinedUnitWrapper m_leftJoinedUnitWrapper;
    private ETJoinedUnitWrapper m_rightJoinedUnitWrapper;
    private LinkedList<ETBooleanExpr> m_filters;

    public NBFallBackJoinAlgorithm(ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, AEJoin.AEJoinType aEJoinType, ETCancelState eTCancelState, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties) throws ErrorException {
        boolean[] blArray = NBFallBackJoinAlgorithm.extractDataNeeded(eTRelationalExpr);
        boolean[] blArray2 = NBFallBackJoinAlgorithm.extractDataNeeded(eTRelationalExpr2);
        this.m_leftJoinedUnitWrapper = new ETJoinedUnitWrapper(eTRelationalExpr, blArray);
        this.m_rightJoinedUnitWrapper = new ETJoinedUnitWrapper(eTRelationalExpr2, blArray2);
        this.m_filters = new LinkedList();
        this.m_fallBack = new NBJoinAlgorithm(eTRelationalExpr, eTRelationalExpr2, aEJoinType, externalAlgorithmProperties, eTCancelState, externalAlgorithmProperties.getLogger());
    }

    public void addFilter(int n, int n2, AEComparisonType aEComparisonType) throws ErrorException {
        ETComparison eTComparison;
        ETColumnRef eTColumnRef = new ETColumnRef(this.m_leftJoinedUnitWrapper, n, false);
        ETColumnRef eTColumnRef2 = new ETColumnRef(this.m_rightJoinedUnitWrapper, n2, false);
        switch (aEComparisonType) {
            case EQUAL: {
                IColumn iColumn = this.m_leftJoinedUnitWrapper.getColumn(n);
                eTComparison = new ETComparison(iColumn, eTColumnRef, eTColumnRef2, BooleanFunctorFactory.getBoolCompFunctor(AEComparisonType.EQUAL, iColumn.getTypeMetadata()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Only equal filter is supported.");
            }
        }
        assert (eTComparison != null);
        this.m_filters.add(eTComparison);
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_fallBack.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_fallBack.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_fallBack.getRequiredMemory();
    }

    @Override
    public Pair<? extends IJoinUnit, ? extends IJoinUnit> loadNextJoinUnit() throws ErrorException {
        Pair<? extends IJoinUnit, ? extends IJoinUnit> pair = this.m_fallBack.loadNextJoinUnit();
        if (pair != null) {
            this.m_leftJoinedUnitWrapper.setJoinUnit(pair.key());
            this.m_rightJoinedUnitWrapper.setJoinUnit(pair.value());
        }
        return pair;
    }

    @Override
    public boolean isMasterJoinUnitOnLeft() {
        return this.m_fallBack.isMasterJoinUnitOnLeft();
    }

    @Override
    public void match() throws ErrorException {
        this.m_fallBack.match();
    }

    @Override
    public boolean isOuterRow() {
        return this.m_fallBack.isOuterRow();
    }

    @Override
    public boolean moveMaster() throws ErrorException {
        return this.m_fallBack.moveMaster();
    }

    @Override
    public boolean moveSlave() throws ErrorException {
        boolean bl;
        while ((bl = this.m_fallBack.moveSlave()) && !this.m_fallBack.isOuterRow() && !this.evaluate()) {
        }
        return bl;
    }

    @Override
    public void seekSlave() {
        this.m_fallBack.seekSlave();
    }

    @Override
    public void closeRelations() {
        this.m_fallBack.closeRelations();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_fallBack.open(cursorType);
    }

    @Override
    public void reset() throws ErrorException {
        this.m_fallBack.reset();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_fallBack.registerWarningListener(iWarningListener);
    }

    private boolean evaluate() throws ErrorException {
        for (ETBooleanExpr eTBooleanExpr : this.m_filters) {
            if (eTBooleanExpr.evaluate() == ETBoolean.SQL_BOOLEAN_TRUE) continue;
            return false;
        }
        return true;
    }

    private static boolean[] extractDataNeeded(ETRelationalExpr eTRelationalExpr) {
        boolean[] blArray = new boolean[eTRelationalExpr.getColumnCount()];
        for (int i = 0; i < eTRelationalExpr.getColumnCount(); ++i) {
            if (!eTRelationalExpr.getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        return blArray;
    }
}

