/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.IMemoryConsumer;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.amazon.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ETSort
extends ETUnaryRelationalExpr
implements IMemoryConsumer {
    private final List<? extends IColumn> m_columns;
    private final SortedTemporaryTable m_tempTable;

    public ETSort(ETRelationalExpr eTRelationalExpr, List<? extends IColumn> list, SortedTemporaryTable sortedTemporaryTable, boolean[] blArray) throws ErrorException {
        super(eTRelationalExpr, blArray);
        this.m_columns = list;
        this.m_tempTable = sortedTemporaryTable;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_columns.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public long getRowCount() throws ErrorException {
        try {
            return this.getOperand().getRowCount();
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        try {
            this.m_tempTable.open();
            this.m_tempTable.writeFromRelation(this.getOperand());
            this.getOperand().close();
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    public void close() {
        this.m_tempTable.close();
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            this.close();
            throw new IllegalStateException("Reset called before relation is opened.");
        }
        this.m_tempTable.reset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        try {
            return this.m_tempTable.retrieveData(n, eTDataRequest);
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    protected boolean doMove() throws ErrorException {
        try {
            return this.m_tempTable.moveToNextRow();
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_tempTable.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_tempTable.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_tempTable.getRequiredMemory();
    }
}

