/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.IAEBuilder;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.exceptions.SQLEngineMemoryException;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTDefaultVisitor;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.InvalidOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AEBuilderBase<T extends IAENode>
extends PTDefaultVisitor<T>
implements IAEBuilder {
    private AEQueryScope m_queryScope;

    protected AEBuilderBase(AEQueryScope aEQueryScope) {
        this.m_queryScope = aEQueryScope;
    }

    public T build(IPTNode iPTNode) throws ErrorException {
        try {
            return (T)((IAENode)iPTNode.acceptVisitor(this));
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
    }

    protected AEQueryScope getQueryScope() {
        return this.m_queryScope;
    }

    @Override
    protected final T defaultVisit(IPTNode iPTNode) {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iPTNode + " from base AE tree builder class");
    }
}

