/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc41.S41DatabaseMetaData;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PGJDBC41DatabaseMetaData
extends S41DatabaseMetaData {
    public PGJDBC41DatabaseMetaData(IConnection iconn, SConnection sconn, ILogger logger) throws SQLException {
        super(sconn, logger);
        try {
            this.setDefaultProperties((PGJDBCConnection)iconn);
        }
        catch (ErrorException ex) {
            throw ExceptionConverter.getInstance().toSQLException(ex, this.m_warningListener, this.m_logger);
        }
    }

    private void setDefaultProperties(PGJDBCConnection connection) throws ErrorException {
        PGResultSet dbmsInfoResultSet = new PGResultSet(connection.getPostgresqlClient().directExecute("SELECT character_value, version() FROM INFORMATION_SCHEMA.SQL_IMPLEMENTATION_INFO WHERE implementation_info_id = '17' or implementation_info_id = '18'", false, 0, 0, null, true), this.m_logger);
        ArrayList<String> dbmsValueList = new ArrayList<String>();
        boolean COLUMN_SUPPORTED_VALUE_DRIVER_PERPERTY = false;
        boolean COLUMN_VERSION = true;
        String ERROR_VALUE_COLUMN_DRIVER_PERPERTY = "";
        while (dbmsInfoResultSet.hasMoreRows()) {
            String value;
            DataWrapper tempDataWrapper = new DataWrapper();
            if (!dbmsInfoResultSet.moveToNextRow()) continue;
            dbmsInfoResultSet.getData(0, 0L, -1L, tempDataWrapper);
            try {
                value = tempDataWrapper.getVarChar();
                if (null != value) {
                    dbmsValueList.add(value);
                } else {
                    dbmsValueList.add("");
                }
            }
            catch (IncorrectTypeException e) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), e);
            }
            dbmsInfoResultSet.getData(1, 0L, -1L, tempDataWrapper);
            try {
                value = tempDataWrapper.getVarChar();
                if (null == value || !value.matches("(?i:.*redshift.*)")) continue;
                PGCoreUtils.REDSHIFT_SERVER = true;
            }
            catch (IncorrectTypeException e) {
                LogUtilities.logError(e, this.m_logger);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), e.getCause());
            }
        }
        dbmsInfoResultSet.close();
        PGCoreUtils.SERVER_NAME = (String)dbmsValueList.get(0);
        PGCoreUtils.SERVER_VERSION = (String)dbmsValueList.get(1);
        int majorVersionNumber = Integer.parseInt(PGCoreUtils.SERVER_VERSION.split("\\.")[0]);
        if (majorVersionNumber >= 9) {
            connection.getPostgresqlClient().directExecuteImmediately("SET extra_float_digits = 3", null);
        }
        ArrayList<Integer> propertyValueList = new ArrayList<Integer>();
        PGResultSet propertyInfoResultSet = new PGResultSet(connection.getPostgresqlClient().directExecute("SELECT supported_value FROM INFORMATION_SCHEMA.SQL_SIZING WHERE sizing_id = 34 or sizing_id = 30 or sizing_id = 31 or sizing_id = 10005 or sizing_id = 32 or sizing_id = 35 or sizing_id = 107 or sizing_id = 97 or sizing_id = 99 or sizing_id = 100 or sizing_id = 101", false, 0, 0, null, false), this.m_logger);
        boolean SUPPORTED_VALUE_COLUMN_CONN_PROPERTY = false;
        int ERROR_VALUE_COLUMN_CONN_PROPERTY = -1;
        while (propertyInfoResultSet.hasMoreRows()) {
            DataWrapper tempDataWrapper = new DataWrapper();
            propertyInfoResultSet.moveToNextRow();
            propertyInfoResultSet.getData(0, 0L, -1L, tempDataWrapper);
            try {
                int tempPropertyValue = -1;
                if (null != tempDataWrapper.getInteger()) {
                    tempPropertyValue = PGCoreUtils.safeLongToInt(tempDataWrapper.getInteger());
                }
                propertyValueList.add(tempPropertyValue);
            }
            catch (IncorrectTypeException e) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), e);
            }
        }
        propertyInfoResultSet.close();
        try {
            connection.setProperty(101, new Variant(0, "PostgreSQLJDBCDriver"));
            connection.setProperty(139, new Variant(0, "User"));
            connection.setProperty(22, new Variant(0, connection.getConnectionSettings().m_Schema));
            connection.setProperty(58, new Variant(0, "\""));
            connection.setProperty(80, new Variant(0, "N"));
            connection.setProperty(69, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(0)).intValue())));
            connection.setProperty(71, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(1)).intValue())));
            connection.setProperty(72, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(2)).intValue())));
            connection.setProperty(73, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(3)).intValue())));
            connection.setProperty(66, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(4)).intValue())));
            connection.setProperty(68, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(5)).intValue())));
            connection.setProperty(75, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(6)).intValue())));
            connection.setProperty(76, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(7)).intValue())));
            connection.setProperty(81, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(8)).intValue())));
            connection.setProperty(83, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(9)).intValue())));
            connection.setProperty(85, new Variant(2, Character.valueOf((char)((Integer)propertyValueList.get(10)).intValue())));
            connection.setProperty(41, new Variant(0, PGCoreUtils.SERVER_NAME));
            connection.setProperty(42, new Variant(0, PGCoreUtils.SERVER_VERSION));
            connection.setProperty(74, new Variant(2, Character.valueOf('\u0001')));
        }
        catch (Exception e) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), e.getCause());
        }
    }
}

