/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.dataengine.impl.DSISimpleArray;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.exceptions.ErrorException;

public class PGArray
extends DSISimpleArray {
    public PGArray(Object array, IColumn arrayMetadata, IColumn nestedMetadata) {
        super(array, arrayMetadata, nestedMetadata);
    }

    @Override
    public Object createArray(long offset, int count) throws ErrorException {
        if (offset < 0L) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_INDEX_ERR.name());
            throw err;
        }
        if (offset > 0L && count < 0) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_COUNT_ERR.name());
            throw err;
        }
        if ((long)count > (long)this.m_length - offset || offset >= (long)this.m_length) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SUBARRAY_INVALID_ELEMENT_COUNT_ERR.name());
            throw err;
        }
        return super.createArray(offset, count);
    }

    @Override
    public String getStringRepresentation() {
        Object[] array = (Object[])this.m_array;
        if (array == null) {
            return "null";
        }
        int iMax = array.length - 1;
        if (iMax == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        while (true) {
            sb.append(String.valueOf(array[i]));
            if (i == iMax) {
                return sb.append('}').toString();
            }
            sb.append(",");
            ++i;
        }
    }
}

