/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Execute
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_portalName;
    private final int m_rowLimit;

    public Execute(byte[] portalName, int rowLimit, IPGLogger logger) {
        this.m_portalName = portalName;
        this.m_rowLimit = rowLimit;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)69);
        buffer.put(sizebytes);
        if (null != this.m_portalName) {
            buffer.put(this.m_portalName);
        }
        buffer.put(TERMINATOR);
        buffer.put(this.toBytes(this.m_rowLimit));
    }

    @Override
    public int getSize() {
        return 4 + (this.m_portalName != null ? this.m_portalName.length : 0) + 1 + 4;
    }

    public void logMessageContent(IPGLogger logger) {
        String portalname = null;
        if (null != this.m_portalName) {
            portalname = new String(this.m_portalName);
        }
        String message = "=>FE Excecute(portal=" + portalname + ",nbRowToReturn=" + this.m_rowLimit + ")";
        logger.logDebugExternal(message);
    }
}

