/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class CopyData
extends AbstractOutboundMessage
implements PGConstants {
    private byte[] data;
    private int size;

    public CopyData(byte[] data, int size, IPGLogger logger) {
        this.data = data;
        this.size = size;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public int getSize() {
        return 4 + this.size;
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)100);
        buffer.put(sizebytes);
        buffer.put(this.data);
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "=>FE CopyData(" + this.size + ")";
        logger.logDebugExternal(message);
    }
}

