/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class CancelRequest
extends AbstractOutboundMessage
implements PGConstants {
    private static int CANCEL_CODE = 80877102;
    private final KeyData m_key;

    public CancelRequest(KeyData key, IPGLogger logger) {
        this.m_key = key;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put(sizebytes);
        buffer.putInt(CANCEL_CODE);
        buffer.put(this.m_key.getProcessID());
        buffer.put(this.m_key.getSecretKey());
    }

    @Override
    public int getSize() {
        return 16;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "=>FE CancelRequest";
        logger.logDebugExternal(message);
    }
}

