/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CopyInResponse
extends AbstractInboundMessage {
    private boolean m_overallFormat;
    private short m_numOfColumns;
    private boolean[] m_columnFormat;

    public CopyInResponse(ByteBuffer buffer, IPGLogger logger) {
        this.m_overallFormat = buffer.get() != 0;
        this.m_numOfColumns = buffer.getShort();
        this.m_columnFormat = new boolean[this.m_numOfColumns];
        for (int i = 0; i < this.m_numOfColumns; ++i) {
            this.m_columnFormat[i] = buffer.getChar() != '\u0000';
        }
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public boolean getOverallFormat() {
        return this.m_overallFormat;
    }

    public int getNumOfColumns() {
        return this.m_numOfColumns;
    }

    public boolean[] getColumnFormat() {
        return this.m_columnFormat;
    }

    public void logMessageContent(IPGLogger logger) {
        StringBuilder str = new StringBuilder();
        str.append("<=BE CopyInResponse (");
        str.append(this.m_overallFormat);
        str.append(",");
        str.append(this.m_numOfColumns);
        str.append(",");
        str.append(Arrays.toString(this.m_columnFormat));
        str.append(")");
        logger.logDebugExternal(str.toString());
    }
}

