/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.utils;

import com.amazon.support.exceptions.ErrorException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class DataTypeUtilities {
    private static final int NUMBER_OF_POWERS_OF_10 = 18;
    private static final long[] POWERS_OF_10 = new long[19];
    private static final CalculateMantissa[] MANTISSA_CALCULATORS = new CalculateMantissa[19];

    public static byte[] toHexString(byte[] bytes) {
        byte[] hexArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return hexChars;
    }

    public static final String toUTF8String(byte[] value) {
        String tempString = null;
        try {
            tempString = new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            tempString = new String(value);
        }
        return tempString;
    }

    public static final String toUTF8String(byte[] value, int begin, int length) {
        String tempString = null;
        try {
            tempString = new String(value, begin, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            tempString = new String(value, begin, length);
        }
        return tempString;
    }

    public static final byte[] toUTF8ByteArray(String value) {
        byte[] tempArray = null;
        try {
            tempArray = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            tempArray = value.getBytes();
        }
        return tempArray;
    }

    public static int toInt(byte[] bytes) {
        switch (bytes.length) {
            case 4: {
                return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            }
            case 3: {
                return (bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF;
            }
            case 2: {
                return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
            }
        }
        return bytes[0] & 0xFF;
    }

    public static long toLong(byte[] bytes, int beginIndex, int length) throws ErrorException {
        boolean isSign;
        if (18 < length) {
            String str = DataTypeUtilities.toUTF8String(bytes, beginIndex, length);
            BigDecimal bigDecimal = new BigDecimal(str);
            return bigDecimal.longValue();
        }
        int currentIndex = beginIndex;
        char currentCharacter = (char)bytes[currentIndex];
        boolean bl = isSign = '-' == currentCharacter;
        if (isSign) {
            currentCharacter = (char)bytes[++currentIndex];
            --length;
        }
        long value = DataTypeUtilities.toMantissa(bytes, currentIndex, length);
        return isSign ? -value : value;
    }

    public static short toShort(byte[] bytes, int beginIndex, int length) throws ErrorException {
        return (short)DataTypeUtilities.toLong(bytes, beginIndex, length);
    }

    public static int toInteger(byte[] bytes, int beginIndex, int length) throws ErrorException {
        return (int)DataTypeUtilities.toLong(bytes, beginIndex, length);
    }

    public static float toFloat(byte[] bytes, int beginIndex, int length) throws ErrorException {
        return (float)DataTypeUtilities.toDouble(bytes, beginIndex, length);
    }

    public static double toDouble(byte[] bytes, int beginIndex, int length) throws ErrorException {
        NumericRepresentation result = null;
        try {
            result = DataTypeUtilities.buildTotalMantissa(bytes, beginIndex, length);
            if (result.isSmallValue()) {
                if (result.isInfinity) {
                    if (result.isValueNegative) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.POSITIVE_INFINITY;
                }
                if (result.isNan) {
                    return Double.NaN;
                }
                if (0 != result.totalExponent) {
                    if (result.totalExponent >= 18 || -result.totalExponent >= 18) {
                        return BigDecimal.valueOf(result.totalMantissaValue).scaleByPowerOfTen(result.totalExponent).doubleValue();
                    }
                    if (0 < result.totalExponent) {
                        return (double)result.totalMantissaValue * (double)POWERS_OF_10[result.totalExponent];
                    }
                    return (double)result.totalMantissaValue / (double)POWERS_OF_10[-result.totalExponent];
                }
                return result.totalMantissaValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return DataTypeUtilities.getBigDecimal(result).doubleValue();
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int beginIndex, int length) throws ErrorException {
        NumericRepresentation result = null;
        try {
            result = DataTypeUtilities.buildTotalMantissa(bytes, beginIndex, length);
            BigDecimal value = null;
            if (result.isSmallValue()) {
                value = new BigDecimal(result.totalMantissaValue);
                if (0 != result.totalExponent) {
                    return value.scaleByPowerOfTen(result.totalExponent);
                }
                return value;
            }
            return DataTypeUtilities.getBigDecimal(result);
        }
        catch (Exception e) {
            return DataTypeUtilities.getBigDecimal(result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NumericRepresentation parseNumericRepresentation(byte[] bytes, int beginIndex, int length) {
        NumericRepresentation result = new NumericRepresentation();
        result.mantissaValueLength = length--;
        int exponentValueIndex = -1;
        int fractionalValueLength = -1;
        int fractionalValueBeginIndex = -1;
        int exponentValueLength = 0;
        try {
            switch (bytes[beginIndex]) {
                case 45: {
                    result.isValueNegative = true;
                    --result.mantissaValueLength;
                    if (73 != bytes[++beginIndex]) break;
                    result.isInfinity = true;
                    return result;
                }
                case 73: {
                    result.isInfinity = true;
                    return result;
                }
                case 78: {
                    result.isNan = true;
                    return result;
                }
            }
            block15: for (int i = beginIndex; i < beginIndex + length; ++i) {
                switch (bytes[i]) {
                    case 46: {
                        result.hasFractionalValue = true;
                        fractionalValueBeginIndex = i + 1;
                        fractionalValueLength = beginIndex + length - fractionalValueBeginIndex;
                        result.mantissaValueLength = i - beginIndex;
                        break;
                    }
                    case 69: 
                    case 101: {
                        result.hasExponentValue = true;
                        exponentValueIndex = i + 1;
                        exponentValueLength = beginIndex + length - exponentValueIndex;
                        if (!result.hasFractionalValue) {
                            result.mantissaValueLength = i - beginIndex;
                            break block15;
                        }
                        fractionalValueLength = i - fractionalValueBeginIndex;
                        break block15;
                    }
                }
            }
            if (result.hasExponentValue) {
                switch (bytes[exponentValueIndex]) {
                    case 45: {
                        result.isExponentNegative = true;
                    }
                    case 43: {
                        ++exponentValueIndex;
                        --exponentValueLength;
                        break;
                    }
                }
                result.exponentValue = (short)DataTypeUtilities.toMantissa(bytes, exponentValueIndex, exponentValueLength);
            }
            if (result.hasFractionalValue) {
                result.fractionalSignificantDigits = (short)fractionalValueLength;
                int decimalEndIndex = fractionalValueLength - 1 + fractionalValueBeginIndex;
                while (fractionalValueBeginIndex <= decimalEndIndex && 48 == bytes[fractionalValueBeginIndex]) {
                    result.fractionalLeadingZeros = (short)(result.fractionalLeadingZeros + 1);
                    --fractionalValueLength;
                    ++fractionalValueBeginIndex;
                }
            }
            if (result.hasExponentValue) {
                result.totalExponent = (short)((result.isExponentNegative ? -result.exponentValue : result.exponentValue) - result.fractionalSignificantDigits);
            } else if (result.hasFractionalValue) {
                result.totalExponent = -result.fractionalSignificantDigits;
            }
            if (result.fractionalSignificantDigits > 0 && result.fractionalLeadingZeros != result.fractionalSignificantDigits) {
                if (18 >= result.fractionalSignificantDigits) {
                    result.fractionalValue = DataTypeUtilities.toMantissa(bytes, fractionalValueBeginIndex, fractionalValueLength);
                } else {
                    result.fractionalElements = DataTypeUtilities.toMantissaElements(bytes, fractionalValueBeginIndex, fractionalValueLength);
                }
            }
            if (18 >= result.mantissaValueLength) {
                result.mantissaValue = DataTypeUtilities.toMantissa(bytes, beginIndex, result.mantissaValueLength);
                return result;
            }
            result.mantissaElements = DataTypeUtilities.toMantissaElements(bytes, beginIndex, result.mantissaValueLength);
            return result;
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private static long[] toMantissaElements(byte[] bytes, int beginIndex, int length) {
        int numElements = length / 18;
        if (length % 18 != 0) {
            ++numElements;
        }
        long[] elements = new long[numElements];
        for (int elementArrayIndex = 0; elementArrayIndex < numElements; ++elementArrayIndex) {
            int elementLength = 18 > length ? length : 18;
            elements[elementArrayIndex] = DataTypeUtilities.toMantissa(bytes, beginIndex, elementLength);
            beginIndex += 18;
            length -= 18;
        }
        return elements;
    }

    private static BigDecimal getBigDecimal(NumericRepresentation numericRepresentation) {
        BigDecimal bigDecimal = null;
        BigDecimal fractional = null;
        bigDecimal = null != numericRepresentation.mantissaElements ? DataTypeUtilities.toBigDecimalMantissaValue(numericRepresentation.mantissaElements, numericRepresentation.mantissaValueLength) : new BigDecimal(numericRepresentation.mantissaValue);
        if (numericRepresentation.hasFractionalValue) {
            fractional = null != numericRepresentation.fractionalElements ? DataTypeUtilities.toBigDecimalMantissaValue(numericRepresentation.fractionalElements, numericRepresentation.fractionalSignificantDigits - numericRepresentation.fractionalLeadingZeros) : new BigDecimal(numericRepresentation.fractionalValue);
            bigDecimal = fractional.scaleByPowerOfTen(-numericRepresentation.fractionalSignificantDigits).add(bigDecimal);
        }
        if (numericRepresentation.hasExponentValue) {
            bigDecimal = bigDecimal.scaleByPowerOfTen(numericRepresentation.exponentValue);
        }
        if (numericRepresentation.isValueNegative) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    private static BigDecimal toBigDecimalMantissaValue(long[] elements, int length) {
        BigDecimal bigD = new BigDecimal(elements[0]);
        for (int elementIndex = 1; elementIndex < elements.length; ++elementIndex) {
            int scaleby = 18 > (length -= 18) ? length : 18;
            bigD = bigD.scaleByPowerOfTen(scaleby).add(new BigDecimal(elements[elementIndex]));
        }
        return bigD;
    }

    private static NumericRepresentation buildTotalMantissa(byte[] bytes, int beginIndex, int length) {
        NumericRepresentation numericRepresentation = DataTypeUtilities.parseNumericRepresentation(bytes, beginIndex, length);
        if (numericRepresentation.isSmallValue()) {
            numericRepresentation.totalMantissaValue = numericRepresentation.hasFractionalValue ? numericRepresentation.mantissaValue * POWERS_OF_10[numericRepresentation.fractionalSignificantDigits] + numericRepresentation.fractionalValue : numericRepresentation.mantissaValue;
            if (numericRepresentation.isValueNegative) {
                numericRepresentation.totalMantissaValue = -numericRepresentation.totalMantissaValue;
            }
        }
        return numericRepresentation;
    }

    private static long toMantissa(byte[] bytes, int beginIndex, int length) {
        return MANTISSA_CALCULATORS[length].calculate(bytes, beginIndex, length);
    }

    static {
        for (int i = 18; i > 0; --i) {
            DataTypeUtilities.POWERS_OF_10[i] = (long)Math.pow(10.0, i);
        }
        DataTypeUtilities.MANTISSA_CALCULATORS[1] = new CalculateMantissa_Length_1();
        DataTypeUtilities.MANTISSA_CALCULATORS[2] = new CalculateMantissa_Length_2();
        DataTypeUtilities.MANTISSA_CALCULATORS[3] = new CalculateMantissa_Length_3();
        DataTypeUtilities.MANTISSA_CALCULATORS[4] = new CalculateMantissa_Length_4();
        DataTypeUtilities.MANTISSA_CALCULATORS[5] = new CalculateMantissa_Length_5();
        DataTypeUtilities.MANTISSA_CALCULATORS[6] = new CalculateMantissa_Length_6();
        DataTypeUtilities.MANTISSA_CALCULATORS[7] = new CalculateMantissa_Length_7();
        DataTypeUtilities.MANTISSA_CALCULATORS[8] = new CalculateMantissa_Length_8();
        DataTypeUtilities.MANTISSA_CALCULATORS[9] = new CalculateMantissa_Length_9();
        DataTypeUtilities.MANTISSA_CALCULATORS[10] = new CalculateMantissa_Length_10();
        DataTypeUtilities.MANTISSA_CALCULATORS[11] = new CalculateMantissa_Length_11();
        DataTypeUtilities.MANTISSA_CALCULATORS[12] = new CalculateMantissa_Length_12();
        DataTypeUtilities.MANTISSA_CALCULATORS[13] = new CalculateMantissa_Length_13();
        DataTypeUtilities.MANTISSA_CALCULATORS[14] = new CalculateMantissa_Length_14();
        DataTypeUtilities.MANTISSA_CALCULATORS[15] = new CalculateMantissa_Length_15();
        DataTypeUtilities.MANTISSA_CALCULATORS[16] = new CalculateMantissa_Length_16();
        DataTypeUtilities.MANTISSA_CALCULATORS[17] = new CalculateMantissa_Length_17();
        DataTypeUtilities.MANTISSA_CALCULATORS[18] = new CalculateMantissa_Length_18();
    }

    private static class CalculateMantissa_Length_1
    extends CalculateMantissa {
        private CalculateMantissa_Length_1() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            return bytes[beginIndex] - 48;
        }
    }

    private static class CalculateMantissa_Length_2
    extends CalculateMantissa {
        private CalculateMantissa_Length_2() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[1] + (long)(bytes[1] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 1] - 48);
        }
    }

    private static class CalculateMantissa_Length_3
    extends CalculateMantissa {
        private CalculateMantissa_Length_3() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[2] + (long)(bytes[1] - 48) * POWERS_OF_10[1] + (long)(bytes[2] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 2] - 48);
        }
    }

    private static class CalculateMantissa_Length_4
    extends CalculateMantissa {
        private CalculateMantissa_Length_4() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[3] + (long)(bytes[1] - 48) * POWERS_OF_10[2] + (long)(bytes[2] - 48) * POWERS_OF_10[1] + (long)(bytes[3] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 3] - 48);
        }
    }

    private static class CalculateMantissa_Length_5
    extends CalculateMantissa {
        private CalculateMantissa_Length_5() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[4] + (long)(bytes[1] - 48) * POWERS_OF_10[3] + (long)(bytes[2] - 48) * POWERS_OF_10[2] + (long)(bytes[3] - 48) * POWERS_OF_10[1] + (long)(bytes[4] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 4] - 48);
        }
    }

    private static class CalculateMantissa_Length_6
    extends CalculateMantissa {
        private CalculateMantissa_Length_6() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[5] + (long)(bytes[1] - 48) * POWERS_OF_10[4] + (long)(bytes[2] - 48) * POWERS_OF_10[3] + (long)(bytes[3] - 48) * POWERS_OF_10[2] + (long)(bytes[4] - 48) * POWERS_OF_10[1] + (long)(bytes[5] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 5] - 48);
        }
    }

    private static class CalculateMantissa_Length_7
    extends CalculateMantissa {
        private CalculateMantissa_Length_7() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[6] + (long)(bytes[1] - 48) * POWERS_OF_10[5] + (long)(bytes[2] - 48) * POWERS_OF_10[4] + (long)(bytes[3] - 48) * POWERS_OF_10[3] + (long)(bytes[4] - 48) * POWERS_OF_10[2] + (long)(bytes[5] - 48) * POWERS_OF_10[1] + (long)(bytes[6] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 6] - 48);
        }
    }

    private static class CalculateMantissa_Length_8
    extends CalculateMantissa {
        private CalculateMantissa_Length_8() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[7] + (long)(bytes[1] - 48) * POWERS_OF_10[6] + (long)(bytes[2] - 48) * POWERS_OF_10[5] + (long)(bytes[3] - 48) * POWERS_OF_10[4] + (long)(bytes[4] - 48) * POWERS_OF_10[3] + (long)(bytes[5] - 48) * POWERS_OF_10[2] + (long)(bytes[6] - 48) * POWERS_OF_10[1] + (long)(bytes[7] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 7] - 48);
        }
    }

    private static class CalculateMantissa_Length_9
    extends CalculateMantissa {
        private CalculateMantissa_Length_9() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[8] + (long)(bytes[1] - 48) * POWERS_OF_10[7] + (long)(bytes[2] - 48) * POWERS_OF_10[6] + (long)(bytes[3] - 48) * POWERS_OF_10[5] + (long)(bytes[4] - 48) * POWERS_OF_10[4] + (long)(bytes[5] - 48) * POWERS_OF_10[3] + (long)(bytes[6] - 48) * POWERS_OF_10[2] + (long)(bytes[7] - 48) * POWERS_OF_10[1] + (long)(bytes[8] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 8] - 48);
        }
    }

    private static class CalculateMantissa_Length_10
    extends CalculateMantissa {
        private CalculateMantissa_Length_10() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[9] + (long)(bytes[1] - 48) * POWERS_OF_10[8] + (long)(bytes[2] - 48) * POWERS_OF_10[7] + (long)(bytes[3] - 48) * POWERS_OF_10[6] + (long)(bytes[4] - 48) * POWERS_OF_10[5] + (long)(bytes[5] - 48) * POWERS_OF_10[4] + (long)(bytes[6] - 48) * POWERS_OF_10[3] + (long)(bytes[7] - 48) * POWERS_OF_10[2] + (long)(bytes[8] - 48) * POWERS_OF_10[1] + (long)(bytes[9] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 9] - 48);
        }
    }

    private static class CalculateMantissa_Length_11
    extends CalculateMantissa {
        private CalculateMantissa_Length_11() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[10] + (long)(bytes[1] - 48) * POWERS_OF_10[9] + (long)(bytes[2] - 48) * POWERS_OF_10[8] + (long)(bytes[3] - 48) * POWERS_OF_10[7] + (long)(bytes[4] - 48) * POWERS_OF_10[6] + (long)(bytes[5] - 48) * POWERS_OF_10[5] + (long)(bytes[6] - 48) * POWERS_OF_10[4] + (long)(bytes[7] - 48) * POWERS_OF_10[3] + (long)(bytes[8] - 48) * POWERS_OF_10[2] + (long)(bytes[9] - 48) * POWERS_OF_10[1] + (long)(bytes[10] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 10] - 48);
        }
    }

    private static class CalculateMantissa_Length_12
    extends CalculateMantissa {
        private CalculateMantissa_Length_12() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[11] + (long)(bytes[1] - 48) * POWERS_OF_10[10] + (long)(bytes[2] - 48) * POWERS_OF_10[9] + (long)(bytes[3] - 48) * POWERS_OF_10[8] + (long)(bytes[4] - 48) * POWERS_OF_10[7] + (long)(bytes[5] - 48) * POWERS_OF_10[6] + (long)(bytes[6] - 48) * POWERS_OF_10[5] + (long)(bytes[7] - 48) * POWERS_OF_10[4] + (long)(bytes[8] - 48) * POWERS_OF_10[3] + (long)(bytes[9] - 48) * POWERS_OF_10[2] + (long)(bytes[10] - 48) * POWERS_OF_10[1] + (long)(bytes[11] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 11] - 48);
        }
    }

    private static class CalculateMantissa_Length_13
    extends CalculateMantissa {
        private CalculateMantissa_Length_13() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[12] + (long)(bytes[1] - 48) * POWERS_OF_10[11] + (long)(bytes[2] - 48) * POWERS_OF_10[10] + (long)(bytes[3] - 48) * POWERS_OF_10[9] + (long)(bytes[4] - 48) * POWERS_OF_10[8] + (long)(bytes[5] - 48) * POWERS_OF_10[7] + (long)(bytes[6] - 48) * POWERS_OF_10[6] + (long)(bytes[7] - 48) * POWERS_OF_10[5] + (long)(bytes[8] - 48) * POWERS_OF_10[4] + (long)(bytes[9] - 48) * POWERS_OF_10[3] + (long)(bytes[10] - 48) * POWERS_OF_10[2] + (long)(bytes[11] - 48) * POWERS_OF_10[1] + (long)(bytes[12] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 12] - 48);
        }
    }

    private static class CalculateMantissa_Length_14
    extends CalculateMantissa {
        private CalculateMantissa_Length_14() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[13] + (long)(bytes[1] - 48) * POWERS_OF_10[12] + (long)(bytes[2] - 48) * POWERS_OF_10[11] + (long)(bytes[3] - 48) * POWERS_OF_10[10] + (long)(bytes[4] - 48) * POWERS_OF_10[9] + (long)(bytes[5] - 48) * POWERS_OF_10[8] + (long)(bytes[6] - 48) * POWERS_OF_10[7] + (long)(bytes[7] - 48) * POWERS_OF_10[6] + (long)(bytes[8] - 48) * POWERS_OF_10[5] + (long)(bytes[9] - 48) * POWERS_OF_10[4] + (long)(bytes[10] - 48) * POWERS_OF_10[3] + (long)(bytes[11] - 48) * POWERS_OF_10[2] + (long)(bytes[12] - 48) * POWERS_OF_10[1] + (long)(bytes[13] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[13] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 12] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 13] - 48);
        }
    }

    private static class CalculateMantissa_Length_15
    extends CalculateMantissa {
        private CalculateMantissa_Length_15() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[14] + (long)(bytes[1] - 48) * POWERS_OF_10[13] + (long)(bytes[2] - 48) * POWERS_OF_10[12] + (long)(bytes[3] - 48) * POWERS_OF_10[11] + (long)(bytes[4] - 48) * POWERS_OF_10[10] + (long)(bytes[5] - 48) * POWERS_OF_10[9] + (long)(bytes[6] - 48) * POWERS_OF_10[8] + (long)(bytes[7] - 48) * POWERS_OF_10[7] + (long)(bytes[8] - 48) * POWERS_OF_10[6] + (long)(bytes[9] - 48) * POWERS_OF_10[5] + (long)(bytes[10] - 48) * POWERS_OF_10[4] + (long)(bytes[11] - 48) * POWERS_OF_10[3] + (long)(bytes[12] - 48) * POWERS_OF_10[2] + (long)(bytes[13] - 48) * POWERS_OF_10[1] + (long)(bytes[14] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[14] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[13] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 12] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 13] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 14] - 48);
        }
    }

    private static class CalculateMantissa_Length_16
    extends CalculateMantissa {
        private CalculateMantissa_Length_16() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[15] + (long)(bytes[1] - 48) * POWERS_OF_10[14] + (long)(bytes[2] - 48) * POWERS_OF_10[13] + (long)(bytes[3] - 48) * POWERS_OF_10[12] + (long)(bytes[4] - 48) * POWERS_OF_10[11] + (long)(bytes[5] - 48) * POWERS_OF_10[10] + (long)(bytes[6] - 48) * POWERS_OF_10[9] + (long)(bytes[7] - 48) * POWERS_OF_10[8] + (long)(bytes[8] - 48) * POWERS_OF_10[7] + (long)(bytes[9] - 48) * POWERS_OF_10[6] + (long)(bytes[10] - 48) * POWERS_OF_10[5] + (long)(bytes[11] - 48) * POWERS_OF_10[4] + (long)(bytes[12] - 48) * POWERS_OF_10[3] + (long)(bytes[13] - 48) * POWERS_OF_10[2] + (long)(bytes[14] - 48) * POWERS_OF_10[1] + (long)(bytes[15] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[15] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[14] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[13] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 12] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 13] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 14] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 15] - 48);
        }
    }

    private static class CalculateMantissa_Length_17
    extends CalculateMantissa {
        private CalculateMantissa_Length_17() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[16] + (long)(bytes[1] - 48) * POWERS_OF_10[15] + (long)(bytes[2] - 48) * POWERS_OF_10[14] + (long)(bytes[3] - 48) * POWERS_OF_10[13] + (long)(bytes[4] - 48) * POWERS_OF_10[12] + (long)(bytes[5] - 48) * POWERS_OF_10[11] + (long)(bytes[6] - 48) * POWERS_OF_10[10] + (long)(bytes[7] - 48) * POWERS_OF_10[9] + (long)(bytes[8] - 48) * POWERS_OF_10[8] + (long)(bytes[9] - 48) * POWERS_OF_10[7] + (long)(bytes[10] - 48) * POWERS_OF_10[6] + (long)(bytes[11] - 48) * POWERS_OF_10[5] + (long)(bytes[12] - 48) * POWERS_OF_10[4] + (long)(bytes[13] - 48) * POWERS_OF_10[3] + (long)(bytes[14] - 48) * POWERS_OF_10[2] + (long)(bytes[15] - 48) * POWERS_OF_10[1] + (long)(bytes[16] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[16] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[15] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[14] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[13] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 12] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 13] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 14] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 15] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 16] - 48);
        }
    }

    private static class CalculateMantissa_Length_18
    extends CalculateMantissa {
        private CalculateMantissa_Length_18() {
        }

        @Override
        public long calculate(byte[] bytes, int beginIndex, int length) {
            if (0 == beginIndex) {
                return (long)(bytes[0] - 48) * POWERS_OF_10[17] + (long)(bytes[1] - 48) * POWERS_OF_10[16] + (long)(bytes[2] - 48) * POWERS_OF_10[15] + (long)(bytes[3] - 48) * POWERS_OF_10[14] + (long)(bytes[4] - 48) * POWERS_OF_10[13] + (long)(bytes[5] - 48) * POWERS_OF_10[12] + (long)(bytes[6] - 48) * POWERS_OF_10[11] + (long)(bytes[7] - 48) * POWERS_OF_10[10] + (long)(bytes[8] - 48) * POWERS_OF_10[9] + (long)(bytes[9] - 48) * POWERS_OF_10[8] + (long)(bytes[10] - 48) * POWERS_OF_10[7] + (long)(bytes[11] - 48) * POWERS_OF_10[6] + (long)(bytes[12] - 48) * POWERS_OF_10[5] + (long)(bytes[13] - 48) * POWERS_OF_10[4] + (long)(bytes[14] - 48) * POWERS_OF_10[3] + (long)(bytes[15] - 48) * POWERS_OF_10[2] + (long)(bytes[16] - 48) * POWERS_OF_10[1] + (long)(bytes[17] - 48);
            }
            return (long)(bytes[beginIndex] - 48) * POWERS_OF_10[17] + (long)(bytes[beginIndex + 1] - 48) * POWERS_OF_10[16] + (long)(bytes[beginIndex + 2] - 48) * POWERS_OF_10[15] + (long)(bytes[beginIndex + 3] - 48) * POWERS_OF_10[14] + (long)(bytes[beginIndex + 4] - 48) * POWERS_OF_10[13] + (long)(bytes[beginIndex + 5] - 48) * POWERS_OF_10[12] + (long)(bytes[beginIndex + 6] - 48) * POWERS_OF_10[11] + (long)(bytes[beginIndex + 7] - 48) * POWERS_OF_10[10] + (long)(bytes[beginIndex + 8] - 48) * POWERS_OF_10[9] + (long)(bytes[beginIndex + 9] - 48) * POWERS_OF_10[8] + (long)(bytes[beginIndex + 10] - 48) * POWERS_OF_10[7] + (long)(bytes[beginIndex + 11] - 48) * POWERS_OF_10[6] + (long)(bytes[beginIndex + 12] - 48) * POWERS_OF_10[5] + (long)(bytes[beginIndex + 13] - 48) * POWERS_OF_10[4] + (long)(bytes[beginIndex + 14] - 48) * POWERS_OF_10[3] + (long)(bytes[beginIndex + 15] - 48) * POWERS_OF_10[2] + (long)(bytes[beginIndex + 16] - 48) * POWERS_OF_10[1] + (long)(bytes[beginIndex + 17] - 48);
        }
    }

    private static class NumericRepresentation {
        boolean isValueNegative;
        long mantissaValue;
        long[] mantissaElements;
        int mantissaValueLength;
        boolean hasFractionalValue = false;
        short fractionalSignificantDigits = 0;
        short fractionalLeadingZeros = 0;
        long fractionalValue;
        long[] fractionalElements;
        boolean hasExponentValue = false;
        boolean isExponentNegative = false;
        short exponentValue = 0;
        boolean isInfinity = false;
        boolean isNan = false;
        long totalMantissaValue;
        short totalExponent = 0;

        private NumericRepresentation() {
        }

        public boolean isSmallValue() {
            return 18 > this.mantissaValueLength + (this.fractionalSignificantDigits != -1 ? this.fractionalSignificantDigits : (short)0);
        }

        public String toString() {
            StringBuilder mantissaString = new StringBuilder();
            if (null != this.mantissaElements) {
                mantissaString.append("{");
                for (long l : this.mantissaElements) {
                    mantissaString.append(l);
                    mantissaString.append(",");
                }
                mantissaString.append("}");
            }
            StringBuilder fractionString = new StringBuilder();
            if (null != this.fractionalElements) {
                fractionString.append("{");
                for (long l : this.fractionalElements) {
                    fractionString.append(l);
                    fractionString.append(",");
                }
                fractionString.append("}");
            }
            return "isValueNegative: " + this.isValueNegative + "\nmantissaValue: " + this.mantissaValue + "\nmantissaElements :" + mantissaString + "\nhasFractionalValue: " + this.hasFractionalValue + "\nfractionalSignificantDigits: " + this.fractionalSignificantDigits + "\nfractionalLeadingZeros: " + this.fractionalLeadingZeros + "\nfractionalValue: " + this.fractionalValue + "\nfractionalElements: " + fractionString + "\nhasExponentValue: " + this.hasExponentValue + "\nisExponentNegative: " + this.isExponentNegative + "\nexponentValue: " + this.exponentValue + "\ntotalMantissaValue: " + this.totalMantissaValue + "\ntotalMantissaValue: " + this.totalExponent;
        }
    }

    static abstract class CalculateMantissa {
        CalculateMantissa() {
        }

        public abstract long calculate(byte[] var1, int var2, int var3);
    }
}

