/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.common.comm.io.BoundedInputStream;
import com.aliyun.oss.common.comm.io.RepeatableBoundedFileInputStream;
import com.aliyun.oss.common.comm.io.RepeatableFileInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.CheckedInputStream;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        String result;
        if (in == null) {
            return "";
        }
        Reader reader = null;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n = -1;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            result = ((Object)writer).toString();
        }
        finally {
            in.close();
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        return result;
    }

    public static byte[] readStreamAsByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = in.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        output.flush();
        return output.toByteArray();
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean checkFile(File file) {
        if (file == null) {
            return false;
        }
        boolean exists = false;
        boolean isFile = false;
        boolean canRead = false;
        try {
            exists = file.exists();
            isFile = file.isFile();
            canRead = file.canRead();
        }
        catch (SecurityException se) {
            return false;
        }
        return exists && isFile && canRead;
    }

    public static InputStream newRepeatableInputStream(InputStream original) throws IOException {
        InputStream repeatable = null;
        repeatable = !original.markSupported() ? (original instanceof FileInputStream ? new RepeatableFileInputStream((FileInputStream)original) : new BufferedInputStream(original, 524288)) : original;
        return repeatable;
    }

    public static InputStream newRepeatableInputStream(BoundedInputStream original) throws IOException {
        InputStream repeatable = null;
        repeatable = !original.markSupported() ? (original.getWrappedInputStream() instanceof FileInputStream ? new RepeatableBoundedFileInputStream(original) : new BufferedInputStream(original, 524288)) : original;
        return repeatable;
    }

    public static Long getCRCValue(InputStream inputStream) {
        if (inputStream instanceof CheckedInputStream) {
            return ((CheckedInputStream)inputStream).getChecksum().getValue();
        }
        return null;
    }

    public static int readNBytes(InputStream inputStream, byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len && (count = inputStream.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }
}

