/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal.signer;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.StringUtils;
import com.aliyun.oss.internal.signer.OSSSignerBase;
import com.aliyun.oss.internal.signer.OSSSignerParams;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class OSSV4Signer
extends OSSSignerBase {
    private static final List<String> DEFAULT_SIGNED_HEADERS = Arrays.asList("Content-Type".toLowerCase(), "Content-MD5".toLowerCase());
    private static final String ISO8601_DATETIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String ISO8601_DATE_FORMAT = "yyyyMMdd";
    private static final String SEPARATOR_BACKSLASH = "/";
    private static final String OSS4_HMAC_SHA256 = "OSS4-HMAC-SHA256";
    private static final String TERMINATOR = "aliyun_v4_request";
    private static final String SECRET_KEY_PREFIX = "aliyun_v4";
    Set<String> additionalSignedHeaders;
    private Date requestDateTime;

    protected OSSV4Signer(OSSSignerParams signerParams) {
        super(signerParams);
    }

    private static DateFormat getIso8601DateTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATETIME_FORMAT, Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df;
    }

    private static DateFormat getIso8601DateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATE_FORMAT, Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df;
    }

    private String getDateTime() {
        return OSSV4Signer.getIso8601DateTimeFormat().format(this.requestDateTime);
    }

    private String getDate() {
        return OSSV4Signer.getIso8601DateFormat().format(this.requestDateTime);
    }

    private boolean hasDefaultSignedHeaders(String header) {
        if (DEFAULT_SIGNED_HEADERS.contains(header)) {
            return true;
        }
        return header.startsWith("x-oss-");
    }

    private boolean hasSignedHeaders(String header) {
        if (this.hasDefaultSignedHeaders(header)) {
            return true;
        }
        return this.additionalSignedHeaders.contains(header);
    }

    private boolean hasAdditionalSignedHeaders() {
        return this.additionalSignedHeaders != null && !this.additionalSignedHeaders.isEmpty();
    }

    private TreeMap<String, String> buildSortedHeadersMap(Map<String, String> headers) {
        TreeMap<String, String> orderMap = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey().toLowerCase();
                if (!this.hasSignedHeaders(key)) continue;
                orderMap.put(key, header.getValue());
            }
        }
        return orderMap;
    }

    private void resolveAdditionalSignedHeaders(RequestMessage request) {
        if (request.getOriginalRequest().getAdditionalHeaderNames().isEmpty()) {
            this.additionalSignedHeaders = request.getOriginalRequest().getAdditionalHeaderNames();
            return;
        }
        TreeSet<String> signedHeaders = new TreeSet<String>();
        for (String additionalHeader : request.getOriginalRequest().getAdditionalHeaderNames()) {
            String additionalHeaderKey = additionalHeader.toLowerCase();
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                String headerKey = header.getKey().toLowerCase();
                if (!headerKey.equals(additionalHeaderKey) || this.hasDefaultSignedHeaders(additionalHeaderKey)) continue;
                signedHeaders.add(additionalHeaderKey);
            }
        }
        this.additionalSignedHeaders = signedHeaders;
    }

    private void addSignedHeaderIfNeeded(RequestMessage request) {
        Set<String> signedHeaders = this.additionalSignedHeaders;
        if (signedHeaders.contains("Host".toLowerCase()) && !request.getHeaders().containsKey("Host")) {
            request.addHeader("Host", request.getEndpoint().getHost());
        }
    }

    private void addOSSContentSha256Header(RequestMessage request) {
        request.addHeader("x-oss-content-sha256", "UNSIGNED-PAYLOAD");
    }

    @Override
    protected void addDateHeaderIfNeeded(RequestMessage request) {
        Date now = new Date();
        if (this.signerParams.getTickOffset() != 0L) {
            now.setTime(now.getTime() + this.signerParams.getTickOffset());
        }
        this.requestDateTime = now;
        request.getHeaders().put("x-oss-date", this.getDateTime());
    }

    private String buildCanonicalRequest(RequestMessage request) {
        String method = request.getMethod().toString();
        String resourcePath = this.signerParams.getResourcePath();
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append("\n");
        canonicalString.append(HttpUtil.urlEncode(resourcePath, true)).append("\n");
        Map<String, String> parameters = request.getParameters();
        TreeMap<Object, Object> orderMap = new TreeMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                orderMap.put(HttpUtil.urlEncode(StringUtils.trim(param.getKey()), false), HttpUtil.urlEncode(StringUtils.trim(param.getValue()), false));
            }
        }
        String separator = "";
        StringBuilder canonicalPart = new StringBuilder();
        for (Map.Entry entry : orderMap.entrySet()) {
            canonicalPart.append(separator).append((String)entry.getKey());
            if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) {
                canonicalPart.append("=").append((String)entry.getValue());
            }
            separator = "&";
        }
        canonicalString.append((CharSequence)canonicalPart).append("\n");
        orderMap = this.buildSortedHeadersMap(request.getHeaders());
        canonicalPart = new StringBuilder();
        for (Map.Entry<Object, Object> entry : orderMap.entrySet()) {
            canonicalPart.append((String)entry.getKey()).append(":").append(((String)entry.getValue()).trim()).append("\n");
        }
        canonicalString.append((CharSequence)canonicalPart).append("\n");
        String canonicalPartStr = StringUtils.join(";", this.additionalSignedHeaders);
        canonicalString.append(canonicalPartStr).append("\n");
        String string = request.getHeaders().get("x-oss-content-sha256");
        canonicalString.append(string);
        return canonicalString.toString();
    }

    private String getRegion() {
        if (this.signerParams.getCloudBoxId() != null) {
            return this.signerParams.getCloudBoxId();
        }
        return this.signerParams.getRegion();
    }

    private String getProduct() {
        return this.signerParams.getProduct();
    }

    private String buildScope() {
        return this.getDate() + SEPARATOR_BACKSLASH + this.getRegion() + SEPARATOR_BACKSLASH + this.getProduct() + SEPARATOR_BACKSLASH + TERMINATOR;
    }

    private String buildStringToSign(String canonicalString) {
        return "OSS4-HMAC-SHA256\n" + this.getDateTime() + "\n" + this.buildScope() + "\n" + BinaryUtil.toHex(BinaryUtil.calculateSha256(canonicalString.getBytes(StringUtils.UTF8)));
    }

    private byte[] buildSigningKey() {
        ServiceSignature signature = ServiceSignature.create("HmacSHA256");
        byte[] signingSecret = (SECRET_KEY_PREFIX + this.signerParams.getCredentials().getSecretAccessKey()).getBytes(StringUtils.UTF8);
        byte[] signingDate = signature.computeHash(signingSecret, this.getDate().getBytes(StringUtils.UTF8));
        byte[] signingRegion = signature.computeHash(signingDate, this.getRegion().getBytes(StringUtils.UTF8));
        byte[] signingService = signature.computeHash(signingRegion, this.getProduct().getBytes(StringUtils.UTF8));
        return signature.computeHash(signingService, TERMINATOR.getBytes(StringUtils.UTF8));
    }

    private String buildSignature(byte[] signingKey, String stringToSign) {
        byte[] result = ServiceSignature.create("HmacSHA256").computeHash(signingKey, stringToSign.getBytes(StringUtils.UTF8));
        return BinaryUtil.toHex(result);
    }

    private String buildAuthorization(String signature) {
        String credential = "Credential=" + this.signerParams.getCredentials().getAccessKeyId() + SEPARATOR_BACKSLASH + this.buildScope();
        String signedHeaders = !this.hasAdditionalSignedHeaders() ? "" : ",AdditionalHeaders=" + StringUtils.join(";", this.additionalSignedHeaders);
        String sign = ",Signature=" + signature;
        return "OSS4-HMAC-SHA256 " + credential + signedHeaders + sign;
    }

    @Override
    protected void addAuthorizationHeader(RequestMessage request) {
        String canonicalRequest = this.buildCanonicalRequest(request);
        String stringToSign = this.buildStringToSign(canonicalRequest);
        byte[] signingKey = this.buildSigningKey();
        String signature = this.buildSignature(signingKey, stringToSign);
        String authorization = this.buildAuthorization(signature);
        request.addHeader("Authorization", authorization);
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        this.addDateHeaderIfNeeded(request);
        if (this.isAnonymous()) {
            return;
        }
        this.resolveAdditionalSignedHeaders(request);
        this.addSignedHeaderIfNeeded(request);
        this.addSecurityTokenHeaderIfNeeded(request);
        this.addOSSContentSha256Header(request);
        this.addAuthorizationHeader(request);
    }
}

