/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.log.common.DashboardBasedJobConfiguration;
import com.aliyun.openservices.log.common.DingTalkNotification;
import com.aliyun.openservices.log.common.EmailNotification;
import com.aliyun.openservices.log.common.MessageCenterNotification;
import com.aliyun.openservices.log.common.Notification;
import com.aliyun.openservices.log.common.NotificationType;
import com.aliyun.openservices.log.common.Query;
import com.aliyun.openservices.log.common.SmsNotification;
import com.aliyun.openservices.log.common.VoiceNotification;
import com.aliyun.openservices.log.common.WebhookNotification;
import com.aliyun.openservices.log.internal.Unmarshaller;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.Utils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AlertConfiguration
extends DashboardBasedJobConfiguration {
    @Deprecated
    @JSONField
    private String condition;
    @JSONField
    private List<Query> queryList;
    @JSONField
    private Date muteUntil;
    @Deprecated
    @JSONField
    private Integer notifyThreshold = 1;
    @JSONField
    private String throttling;
    @Deprecated
    @JSONField
    private boolean sendRecoveryMessage;
    @JSONField
    private boolean autoAnnotation;
    @JSONField
    private String version;
    @JSONField
    private String type;
    @JSONField
    private int threshold = 1;
    @JSONField
    private boolean noDataFire;
    @JSONField
    private int noDataSeverity = Severity.Medium.value();
    @JSONField
    private boolean sendResolved;
    @JSONField
    private TemplateConfiguration templateConfiguration;
    @JSONField
    private ConditionConfiguration conditionConfiguration;
    @JSONField
    private List<Tag> annotations;
    @JSONField
    private List<Tag> labels;
    @JSONField
    private List<SeverityConfiguration> severityConfigurations;
    @JSONField
    private List<JoinConfiguration> joinConfigurations;
    @JSONField
    private GroupConfiguration groupConfiguration;
    @JSONField
    private PolicyConfiguration policyConfiguration;
    @JSONField
    private List<String> tags;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public void setQueryList(List<Query> queryList) {
        this.queryList = queryList;
    }

    public Date getMuteUntil() {
        return this.muteUntil;
    }

    public void setMuteUntil(Date muteUntil) {
        this.muteUntil = muteUntil;
    }

    @Deprecated
    public Integer getNotifyThreshold() {
        return this.notifyThreshold;
    }

    @Deprecated
    public void setNotifyThreshold(Integer notifyThreshold) {
        this.notifyThreshold = notifyThreshold;
    }

    @Deprecated
    public String getThrottling() {
        return this.throttling;
    }

    @Deprecated
    public void setThrottling(String throttling) {
        this.throttling = throttling;
    }

    @Deprecated
    public boolean getSendRecoveryMessage() {
        return this.sendRecoveryMessage;
    }

    @Deprecated
    public void setSendRecoveryMessage(boolean sendRecoveryMessage) {
        this.sendRecoveryMessage = sendRecoveryMessage;
    }

    public boolean isAutoAnnotation() {
        return this.autoAnnotation;
    }

    public void setAutoAnnotation(boolean autoAnnotation) {
        this.autoAnnotation = autoAnnotation;
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        this.setVersion(JsonUtils.readOptionalString(value, "version"));
        if (this.getVersion() != null) {
            this.deserializeAlert2(value);
        } else {
            this.deserializeAlert(value);
        }
    }

    private void deserializeAlert(JSONObject value) {
        this.condition = value.getString("condition");
        this.queryList = JsonUtils.readList(value, "queryList", new Unmarshaller<Query>(){

            @Override
            public Query unmarshal(JSONArray value, int index) {
                Query query = new Query();
                query.deserialize(value.getJSONObject(index));
                return query;
            }
        });
        if (value.containsKey((Object)"muteUntil")) {
            this.muteUntil = Utils.timestampToDate(value.getLong("muteUntil"));
        }
        this.notifyThreshold = JsonUtils.readOptionalInt(value, "notifyThreshold");
        this.throttling = JsonUtils.readOptionalString(value, "throttling");
        this.sendRecoveryMessage = JsonUtils.readBool(value, "sendRecoveryMessage", false);
        if (value.containsKey((Object)"tags")) {
            this.tags = JsonUtils.readStringList(value, "tags");
        }
    }

    private void deserializeAlert2(JSONObject value) {
        Severity severityVal;
        if (value.containsKey((Object)"muteUntil")) {
            this.muteUntil = Utils.timestampToDate(value.getLong("muteUntil"));
        }
        this.setVersion(JsonUtils.readOptionalString(value, "version"));
        this.setType(JsonUtils.readOptionalString(value, "type"));
        if (value.containsKey((Object)"threshold")) {
            this.setThreshold(value.getInteger("threshold"));
        }
        if (value.containsKey((Object)"noDataFire")) {
            this.setNoDataFire(value.getBoolean("noDataFire"));
        }
        if (value.containsKey((Object)"noDataSeverity") && (severityVal = Severity.valueOf(value.getInteger("noDataSeverity"))) != null) {
            this.setNoDataSeverity(severityVal);
        }
        if (value.containsKey((Object)"autoAnnotation")) {
            this.setAutoAnnotation(value.getBoolean("autoAnnotation"));
        }
        if (value.containsKey((Object)"sendResolved")) {
            this.setSendResolved(value.getBoolean("sendResolved"));
        }
        this.templateConfiguration = new TemplateConfiguration();
        if (value.containsKey((Object)"templateConfiguration") && value.getJSONObject("templateConfiguration") != null) {
            this.templateConfiguration.deserialize(value.getJSONObject("templateConfiguration"));
        }
        this.conditionConfiguration = new ConditionConfiguration();
        if (value.containsKey((Object)"conditionConfiguration")) {
            this.conditionConfiguration.deserialize(value.getJSONObject("conditionConfiguration"));
        }
        this.queryList = JsonUtils.readList(value, "queryList", new Unmarshaller<Query>(){

            @Override
            public Query unmarshal(JSONArray value, int index) {
                Query query = new Query();
                query.deserialize(value.getJSONObject(index));
                return query;
            }
        });
        this.annotations = JsonUtils.readList(value, "annotations", new Unmarshaller<Tag>(){

            @Override
            public Tag unmarshal(JSONArray value, int index) {
                Tag tag = new Tag();
                tag.deserialize(value.getJSONObject(index));
                return tag;
            }
        });
        this.labels = JsonUtils.readList(value, "labels", new Unmarshaller<Tag>(){

            @Override
            public Tag unmarshal(JSONArray value, int index) {
                Tag tag = new Tag();
                tag.deserialize(value.getJSONObject(index));
                return tag;
            }
        });
        this.severityConfigurations = JsonUtils.readList(value, "severityConfigurations", new Unmarshaller<SeverityConfiguration>(){

            @Override
            public SeverityConfiguration unmarshal(JSONArray value, int index) {
                SeverityConfiguration severityConfiguration = new SeverityConfiguration();
                severityConfiguration.deserialize(value.getJSONObject(index));
                return severityConfiguration;
            }
        });
        this.joinConfigurations = JsonUtils.readList(value, "joinConfigurations", new Unmarshaller<JoinConfiguration>(){

            @Override
            public JoinConfiguration unmarshal(JSONArray value, int index) {
                JoinConfiguration joinConfiguration = new JoinConfiguration();
                joinConfiguration.deserialize(value.getJSONObject(index));
                return joinConfiguration;
            }
        });
        this.groupConfiguration = new GroupConfiguration();
        if (value.containsKey((Object)"groupConfiguration") && value.getJSONObject("groupConfiguration") != null) {
            this.groupConfiguration.deserialize(value.getJSONObject("groupConfiguration"));
        }
        this.policyConfiguration = new PolicyConfiguration();
        if (value.containsKey((Object)"policyConfiguration") && value.getJSONObject("policyConfiguration") != null) {
            this.policyConfiguration.deserialize(value.getJSONObject("policyConfiguration"));
        }
        if (value.containsKey((Object)"tags")) {
            this.tags = JsonUtils.readStringList(value, "tags");
        }
    }

    @Override
    @Deprecated
    Notification makeQualifiedNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
            case MESSAGE_CENTER: {
                return new MessageCenterNotification();
            }
            case SMS: {
                return new SmsNotification();
            }
            case WEBHOOK: {
                return new WebhookNotification();
            }
            case VOICE: {
                return new VoiceNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented notification type: " + (Object)((Object)type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertConfiguration that = (AlertConfiguration)o;
        if (this.sendRecoveryMessage != that.sendRecoveryMessage) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.queryList != null ? !this.queryList.equals(that.queryList) : that.queryList != null) {
            return false;
        }
        if (this.muteUntil != null ? !this.muteUntil.equals(that.muteUntil) : that.muteUntil != null) {
            return false;
        }
        if (this.notifyThreshold != null ? !this.notifyThreshold.equals(that.notifyThreshold) : that.notifyThreshold != null) {
            return false;
        }
        return this.throttling != null ? this.throttling.equals(that.throttling) : that.throttling == null;
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.queryList != null ? this.queryList.hashCode() : 0);
        result = 31 * result + (this.muteUntil != null ? this.muteUntil.hashCode() : 0);
        result = 31 * result + (this.notifyThreshold != null ? this.notifyThreshold.hashCode() : 0);
        result = 31 * result + (this.throttling != null ? this.throttling.hashCode() : 0);
        result = 31 * result + (this.sendRecoveryMessage ? 1 : 0);
        return result;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isNoDataFire() {
        return this.noDataFire;
    }

    public void setNoDataFire(boolean noDataFire) {
        this.noDataFire = noDataFire;
    }

    public int getNoDataSeverity() {
        return this.noDataSeverity;
    }

    public void setNoDataSeverity(Severity noDataSeverity) {
        this.noDataSeverity = noDataSeverity.value();
    }

    public boolean isSendResolved() {
        return this.sendResolved;
    }

    public void setSendResolved(boolean sendResolved) {
        this.sendResolved = sendResolved;
    }

    public TemplateConfiguration getTemplateConfiguration() {
        return this.templateConfiguration;
    }

    public void setTemplateConfiguration(TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    public ConditionConfiguration getConditionConfiguration() {
        return this.conditionConfiguration;
    }

    public void setConditionConfiguration(ConditionConfiguration conditionConfiguration) {
        this.conditionConfiguration = conditionConfiguration;
    }

    public List<Tag> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Tag> annotations) {
        this.annotations = annotations;
    }

    public List<Tag> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Tag> labels) {
        this.labels = labels;
    }

    public List<SeverityConfiguration> getSeverityConfigurations() {
        return this.severityConfigurations;
    }

    public void setSeverityConfigurations(List<SeverityConfiguration> severityConfigurations) {
        this.severityConfigurations = severityConfigurations;
    }

    public List<JoinConfiguration> getJoinConfigurations() {
        return this.joinConfigurations;
    }

    public void setJoinConfigurations(List<JoinConfiguration> joinConfigurations) {
        this.joinConfigurations = joinConfigurations;
    }

    public GroupConfiguration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public void setGroupConfiguration(GroupConfiguration groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public void setPolicyConfiguration(PolicyConfiguration policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public static class PolicyConfiguration {
        @JSONField
        private String actionPolicyId;
        @JSONField
        private String alertPolicyId;
        @JSONField
        private boolean useDefault;
        @JSONField
        private String repeatInterval;

        public String getActionPolicyId() {
            return this.actionPolicyId;
        }

        public void setActionPolicyId(String actionPolicyId) {
            this.actionPolicyId = actionPolicyId;
        }

        public String getAlertPolicyId() {
            return this.alertPolicyId;
        }

        public void setAlertPolicyId(String alertPolicyId) {
            this.alertPolicyId = alertPolicyId;
        }

        public boolean isUseDefault() {
            return this.useDefault;
        }

        public void setUseDefault(boolean useDefault) {
            this.useDefault = useDefault;
        }

        public String getRepeatInterval() {
            return this.repeatInterval;
        }

        public void setRepeatInterval(String repeatInterval) {
            this.repeatInterval = repeatInterval;
        }

        public void deserialize(JSONObject value) {
            this.setUseDefault(value.getBoolean("useDefault"));
            this.setRepeatInterval(JsonUtils.readOptionalString(value, "repeatInterval"));
            this.setActionPolicyId(JsonUtils.readOptionalString(value, "actionPolicyId"));
            this.setAlertPolicyId(JsonUtils.readOptionalString(value, "alertPolicyId"));
        }
    }

    public static class GroupConfiguration {
        @JSONField
        private String type;
        @JSONField
        private List<String> fields;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void deserialize(JSONObject value) {
            this.setType(value.getString("type"));
            this.setFields(JsonUtils.readStringList(value, "fields"));
        }
    }

    public static class SeverityConfiguration {
        @JSONField
        private int severity;
        @JSONField
        private ConditionConfiguration evalCondition;

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity.value();
        }

        public ConditionConfiguration getEvalCondition() {
            return this.evalCondition;
        }

        public void setEvalCondition(ConditionConfiguration evalCondition) {
            this.evalCondition = evalCondition;
        }

        public void deserialize(JSONObject value) {
            if (value.containsKey((Object)"severity")) {
                this.setSeverity(Severity.valueOf(value.getInteger("severity")));
            }
            this.evalCondition = new ConditionConfiguration();
            if (value.containsKey((Object)"evalCondition") && value.getJSONObject("evalCondition") != null) {
                this.evalCondition.deserialize(value.getJSONObject("evalCondition"));
            }
        }
    }

    public static class Tag {
        @JSONField
        private String key;
        @JSONField
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void deserialize(JSONObject value) {
            if (value != null) {
                this.setKey(value.getString("key"));
                this.setValue(value.getString("value"));
            }
        }
    }

    public static class JoinConfiguration {
        @JSONField
        private String type;
        @JSONField
        private String condition;
        @JSONField
        private String ui;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getUi() {
            return this.ui;
        }

        public void setUi(String ui) {
            this.ui = ui;
        }

        public void deserialize(JSONObject value) {
            this.setType(value.getString("type"));
            this.setCondition(value.getString("condition"));
            this.setUi(value.getString("ui"));
        }
    }

    public static class ConditionConfiguration {
        @JSONField
        private String condition;
        @JSONField
        private String countCondition;

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getCountCondition() {
            return this.countCondition;
        }

        public void setCountCondition(String countCondition) {
            this.countCondition = countCondition;
        }

        public void deserialize(JSONObject value) {
            if (value != null) {
                this.setCondition(JsonUtils.readOptionalString(value, "condition"));
                this.setCountCondition(JsonUtils.readOptionalString(value, "countCondition"));
            }
        }
    }

    public static class TemplateConfiguration {
        @JSONField
        private String id;
        @JSONField
        private String type;
        @JSONField
        private String version;
        @JSONField
        private String lang;
        @JSONField
        private Map<String, String> tokens;
        @JSONField
        private Map<String, String> annotations;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public Map<String, String> getTokens() {
            return this.tokens;
        }

        public void setTokens(Map<String, String> tokens) {
            this.tokens = tokens;
        }

        public Map<String, String> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
        }

        public void deserialize(JSONObject value) {
            this.setId(JsonUtils.readOptionalString(value, "id"));
            this.setType(JsonUtils.readOptionalString(value, "type"));
            this.setLang(JsonUtils.readOptionalString(value, "lang"));
            this.setVersion(JsonUtils.readOptionalString(value, "version"));
            this.setTokens(JsonUtils.readOptionalMap(value, "tokens"));
            this.setAnnotations(JsonUtils.readOptionalMap(value, "annotations"));
        }
    }

    public static enum StoreType implements JSONSerializable
    {
        LOG("log"),
        METRIC("metric"),
        META("meta");

        private final String value;

        private StoreType(String value) {
            this.value = value;
        }

        public static StoreType fromString(String value) {
            for (StoreType type : StoreType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }

        public void write(JSONSerializer serializer, Object fieldName, Type fieldType, int features) {
            serializer.write(this.toString());
        }
    }

    public static enum GroupType implements JSONSerializable
    {
        NO_GROUP("no_group"),
        LABELS_AUTO("labels_auto"),
        CUSTOM("custom");

        private final String value;

        private GroupType(String value) {
            this.value = value;
        }

        public static GroupType fromString(String value) {
            for (GroupType type : GroupType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }

        public void write(JSONSerializer serializer, Object fieldName, Type fieldType, int features) {
            serializer.write(this.toString());
        }
    }

    public static enum JoinType implements JSONSerializable
    {
        CROSS_JOIN("cross_join"),
        INNER_JOIN("inner_join"),
        LEFT_JOIN("left_join"),
        RIGHT_JOIN("right_join"),
        FULL_JOIN("full_join"),
        LEFT_EXCLUDE("left_exclude"),
        RIGHT_EXCLUDE("right_exclude"),
        CONCAT("concat"),
        NO_JOIN("no_join");

        private final String value;

        private JoinType(String value) {
            this.value = value;
        }

        public static JoinType fromString(String value) {
            for (JoinType type : JoinType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }

        public void write(JSONSerializer serializer, Object fieldName, Type fieldType, int features) {
            serializer.write(this.toString());
        }
    }

    public static enum Severity {
        Report(2),
        Low(4),
        Medium(6),
        High(8),
        Critical(10);

        private int value = 0;

        private Severity(int value) {
            this.value = value;
        }

        public static Severity valueOf(int value) {
            switch (value) {
                case 2: {
                    return Report;
                }
                case 4: {
                    return Low;
                }
                case 6: {
                    return Medium;
                }
                case 8: {
                    return High;
                }
                case 10: {
                    return Critical;
                }
            }
            return null;
        }

        public int value() {
            return this.value;
        }
    }
}

