/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.aliyun.log.producer;

import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.common.auth.DefaultCredentials;
import com.aliyun.openservices.log.common.auth.StaticCredentialsProvider;
import javax.annotation.Nullable;

public class ProjectConfig {
    public static final String DEFAULT_USER_AGENT = "aliyun-log-java-producer";
    private final String project;
    private final String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String stsToken;
    private final CredentialsProvider credentialsProvider;
    private final String userAgent;
    private String proxyIp;

    public ProjectConfig(String project, String endpoint, CredentialsProvider credentialsProvider, @Nullable String userAgent) {
        if (project == null) {
            throw new NullPointerException("project cannot be null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint cannot be null");
        }
        if (credentialsProvider == null) {
            throw new NullPointerException("credentialsProvider cannot be null");
        }
        this.project = project;
        this.endpoint = endpoint;
        this.credentialsProvider = credentialsProvider;
        this.userAgent = userAgent;
    }

    public ProjectConfig(String project, String endpoint, String accessKeyId, String accessKeySecret) {
        this(project, endpoint, accessKeyId, accessKeySecret, null, DEFAULT_USER_AGENT);
    }

    public ProjectConfig(String project, String endpoint, String accessKeyId, String accessKeySecret, @Nullable String stsToken) {
        this(project, endpoint, accessKeyId, accessKeySecret, stsToken, DEFAULT_USER_AGENT);
    }

    public ProjectConfig(String project, String endpoint, String accessKeyId, String accessKeySecret, @Nullable String stsToken, @Nullable String userAgent) {
        if (project == null) {
            throw new NullPointerException("project cannot be null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint cannot be null");
        }
        if (accessKeyId == null) {
            throw new NullPointerException("accessKeyId cannot be null");
        }
        if (accessKeySecret == null) {
            throw new NullPointerException("accessKeySecret cannot be null");
        }
        this.project = project;
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.stsToken = stsToken;
        this.userAgent = userAgent;
        this.credentialsProvider = new StaticCredentialsProvider((Credentials)new DefaultCredentials(accessKeyId, accessKeySecret, stsToken));
    }

    public String getProject() {
        return this.project;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Deprecated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Deprecated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Deprecated
    public String getStsToken() {
        return this.stsToken;
    }

    public Credentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
    }
}

