/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;

public class OdpsCommonUtils {
    public static TypeInfo indicateTypeFromClass(Object obj) {
        if (obj == null) {
            return TypeInfoFactory.VOID;
        }
        if (obj instanceof Byte) {
            return TypeInfoFactory.TINYINT;
        }
        if (obj instanceof Short) {
            return TypeInfoFactory.SMALLINT;
        }
        if (obj instanceof Integer) {
            return TypeInfoFactory.INT;
        }
        if (obj instanceof Long) {
            return TypeInfoFactory.BIGINT;
        }
        if (obj instanceof Binary) {
            return TypeInfoFactory.BINARY;
        }
        if (obj instanceof Float) {
            return TypeInfoFactory.FLOAT;
        }
        if (obj instanceof Double) {
            return TypeInfoFactory.DOUBLE;
        }
        if (obj instanceof BigDecimal) {
            return TypeInfoFactory.DECIMAL;
        }
        if (obj instanceof Varchar) {
            return TypeInfoFactory.getVarcharTypeInfo((int)((Varchar)obj).length());
        }
        if (obj instanceof Char) {
            return TypeInfoFactory.getCharTypeInfo((int)((Char)obj).length());
        }
        if (obj instanceof String || obj instanceof byte[]) {
            return TypeInfoFactory.STRING;
        }
        if (obj instanceof java.sql.Date || obj instanceof LocalDate) {
            return TypeInfoFactory.DATE;
        }
        if (obj instanceof Timestamp || obj instanceof Instant) {
            return TypeInfoFactory.TIMESTAMP;
        }
        if (obj instanceof Date || obj instanceof ZonedDateTime) {
            return TypeInfoFactory.DATETIME;
        }
        if (obj instanceof LocalDateTime) {
            return TypeInfoFactory.TIMESTAMP_NTZ;
        }
        if (obj instanceof Boolean) {
            return TypeInfoFactory.BOOLEAN;
        }
        return TypeInfoFactory.UNKNOWN;
    }
}

