/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.commons.transport.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class ConnectionWatcher {
    private static ConnectionWatcher INSTANCE = null;
    private final HashMap<Connection, Timeout> writerTimestamp = new HashMap();
    private static final Logger LOG = Logger.getLogger(ConnectionWatcher.class.getCanonicalName());

    private ConnectionWatcher() {
        new Timer().scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = ConnectionWatcher.this.writerTimestamp;
                synchronized (hashMap) {
                    if (ConnectionWatcher.this.writerTimestamp.isEmpty()) {
                        return;
                    }
                    for (Map.Entry entry : ConnectionWatcher.this.writerTimestamp.entrySet()) {
                        Connection conn = (Connection)entry.getKey();
                        Timeout v = (Timeout)entry.getValue();
                        if (v.isTimedAlready() || !v.timedOut()) continue;
                        try {
                            conn.disconnect();
                            v.setTimedAlready(true);
                        }
                        catch (IOException e) {
                            LOG.warning("Disconnecting timed out connection failed: retried " + v.getRetriedTimes() + " exception " + e.getMessage());
                            if (v.startRetry()) continue;
                            v.setTimedAlready(true);
                        }
                    }
                }
            }
        }, 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(Connection conn, long expectLasts) {
        HashMap<Connection, Timeout> hashMap = this.writerTimestamp;
        synchronized (hashMap) {
            this.writerTimestamp.put(conn, new Timeout(expectLasts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTimedOut(Connection conn) {
        HashMap<Connection, Timeout> hashMap = this.writerTimestamp;
        synchronized (hashMap) {
            Timeout timeout = this.writerTimestamp.getOrDefault(conn, null);
            return timeout != null && timeout.timedOut();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Connection conn) {
        HashMap<Connection, Timeout> hashMap = this.writerTimestamp;
        synchronized (hashMap) {
            if (this.writerTimestamp.containsKey(conn)) {
                this.writerTimestamp.get(conn).resetTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Connection conn) {
        HashMap<Connection, Timeout> hashMap = this.writerTimestamp;
        synchronized (hashMap) {
            this.writerTimestamp.remove(conn);
        }
    }

    public static synchronized ConnectionWatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionWatcher();
        }
        return INSTANCE;
    }

    public class Timeout {
        private long startTime;
        private long expectLasts;
        private boolean timedAlready;
        private int retriedTimes;
        private static final int MAX_RETRY_TIMES = 5;

        public Timeout() {
            this(0L, 0L);
        }

        public Timeout(long expectLs) {
            this(System.currentTimeMillis(), expectLs);
        }

        public Timeout(long startTm, long expectLs) {
            this.startTime = startTm;
            this.expectLasts = expectLs;
            this.timedAlready = false;
            this.retriedTimes = 0;
        }

        public boolean timedOut() {
            long current = System.currentTimeMillis();
            return current - this.startTime > this.expectLasts;
        }

        public void resetTimer() {
            this.startTime = System.currentTimeMillis();
            this.timedAlready = false;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getExpectLasts() {
            return this.expectLasts;
        }

        public void setExpectLasts(long expectLasts) {
            this.expectLasts = expectLasts;
        }

        public boolean isTimedAlready() {
            return this.timedAlready;
        }

        public void setTimedAlready(boolean timedAlready) {
            this.timedAlready = timedAlready;
        }

        public boolean startRetry() {
            if (this.retriedTimes >= 5) {
                return false;
            }
            ++this.retriedTimes;
            return true;
        }

        public int getRetriedTimes() {
            return this.retriedTimes;
        }
    }
}

