/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.commons.util.RetryStrategy;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import java.io.IOException;

public class TunnelBufferedWriter
implements RecordWriter {
    private ProtobufRecordPack bufferedPack;
    private TableTunnel.UploadSession session;
    private long bufferSize;
    private float flushThreshold;
    private long bytesWritten;
    private boolean isClosed;
    private long timeout;
    private TableTunnel.BlockVersionProvider versionProvider;
    private static final long BUFFER_SIZE_DEFAULT = 0x4000000L;
    private static final long BUFFER_SIZE_MIN = 0x100000L;
    private static final long BUFFER_SIZE_MAX = 1048576000L;
    private static final float FLUSH_THRESHOLD_DEFAULT = 0.9f;
    private static final float FLUSH_THRESHOLD_MIN = 0.01f;
    private static final float FLUSH_THRESHOLD_MAX = 0.99f;

    public TunnelBufferedWriter(TableTunnel.UploadSession session, CompressOption option) throws IOException {
        this.bufferedPack = (ProtobufRecordPack)session.newRecordPack(option);
        this.session = session;
        this.bufferSize = 0x4000000L;
        this.flushThreshold = 0.9f;
        this.bytesWritten = 0L;
        this.isClosed = false;
    }

    public TunnelBufferedWriter(TableTunnel.UploadSession session, CompressOption option, long timeout, TableTunnel.BlockVersionProvider versionProvider) throws IOException {
        this(session, option);
        this.timeout = timeout;
        this.versionProvider = versionProvider;
    }

    public void setBufferSize(long bufferSize) {
        if (bufferSize < 0x100000L) {
            throw new IllegalArgumentException("buffer size must >= 1048576, now: " + bufferSize);
        }
        if (bufferSize > 1048576000L) {
            throw new IllegalArgumentException("buffer size must <= 1048576000, now: " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void setFlushThreshold(float flushThreshold) {
        if (flushThreshold < 0.01f) {
            throw new IllegalArgumentException("flush threshold must >= 0.01, now" + flushThreshold);
        }
        if (flushThreshold > 0.99f) {
            throw new IllegalArgumentException("flush threshold must <=0.99, now: " + flushThreshold);
        }
        this.flushThreshold = flushThreshold;
    }

    @Deprecated
    public void setRetryStrategy(RetryStrategy strategy) {
    }

    @Override
    public void write(Record r) throws IOException {
        this.checkStatus();
        if ((float)this.bufferedPack.getTotalBytes() > (float)this.bufferSize * this.flushThreshold) {
            this.flush();
        }
        this.bufferedPack.append(r);
    }

    private void checkStatus() throws IOException {
        if (this.isClosed) {
            throw new IOException("Writer is closed.");
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.isClosed = true;
    }

    public long getTotalBytes() throws IOException {
        this.flush();
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        this.checkStatus();
        long delta = this.bufferedPack.getTotalBytesWritten();
        if (delta > 0L) {
            Long blockId = this.session.getAvailBlockId();
            long version = 0L;
            if (this.versionProvider != null) {
                version = this.versionProvider.generateVersion(blockId);
            }
            if (this.versionProvider != null) {
                try {
                    this.session.writeBlock(blockId, this.bufferedPack, this.timeout, version);
                }
                catch (TunnelException e) {
                    throw new IOException("Generate block version invalid", e);
                }
            } else {
                this.session.writeBlock(blockId, this.bufferedPack, this.timeout);
            }
            this.bufferedPack.reset();
            this.bytesWritten += delta;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

