/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class TunnelTableSchema
extends TableSchema {
    private Map<String, Long> columnIdMap = new HashMap<String, Long>();

    public TunnelTableSchema(JsonObject node) {
        Column col;
        JsonObject column;
        int i;
        JsonArray columns = node.has("columns") ? node.get("columns").getAsJsonArray() : new JsonArray();
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i).getAsJsonObject();
            col = this.parseColumn(column);
            this.addColumn(col);
        }
        columns = node.has("partitionKeys") ? node.get("partitionKeys").getAsJsonArray() : new JsonArray();
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i).getAsJsonObject();
            col = this.parseColumn(column);
            this.addPartitionColumn(col);
        }
    }

    public long getColumnId(String name) throws TunnelException {
        if (!this.columnIdMap.containsKey(name)) {
            throw new TunnelException("Cannot get column '" + name + "' id from schema");
        }
        return this.columnIdMap.get(name);
    }

    private Column parseColumn(JsonObject column) {
        String columnId;
        String name = column.has("name") ? column.get("name").getAsString() : null;
        String type = column.has("type") ? column.get("type").getAsString() : null;
        String comment = column.has("comment") ? column.get("comment").getAsString() : null;
        String nullable = column.has("nullable") ? column.get("nullable").getAsString() : null;
        String string = columnId = column.has("column_id") ? column.get("column_id").getAsString() : null;
        if (!StringUtils.isNullOrEmpty((String)columnId) && !StringUtils.isNullOrEmpty((String)name)) {
            this.columnIdMap.put(name, Long.valueOf(columnId));
        }
        TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)type);
        Column col = new Column(name, typeInfo, comment);
        if (nullable != null) {
            col.setNullable(nullable.equalsIgnoreCase("true"));
        }
        return col;
    }
}

