/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.GeneralConfiguration;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRetryHandler;
import com.aliyun.odps.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class Configuration
extends GeneralConfiguration {
    private CompressOption compressOption = new CompressOption();
    private String quotaName = "";
    private List<String> tags;
    private TunnelRetryHandler.RetryPolicy retryPolicy;
    private RestClient.RetryLogger retryLogger;

    public Configuration(Odps odps) {
        super(odps);
        if (!StringUtils.isNullOrEmpty((String)odps.getTunnelEndpoint())) {
            this.endpoint = URI.create(odps.getTunnelEndpoint());
        }
    }

    public Configuration(Builder builder) {
        super(builder.odps);
        this.retryPolicy = builder.retryPolicy;
        this.quotaName = builder.quotaName;
        this.compressOption = builder.compressOption;
        this.retryLogger = builder.retryLogger;
        this.tags = builder.tags;
    }

    public static Builder builder(Odps odps) {
        return new Builder(odps);
    }

    public CompressOption getCompressOption() {
        return this.compressOption;
    }

    public void setCompressOption(CompressOption option) {
        this.compressOption = option;
    }

    @Override
    public URI getEndpoint(String projectName) throws TunnelException {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        URI u = null;
        try {
            u = new URI(this.odps.projects().get(projectName).getTunnelEndpoint(this.quotaName));
        }
        catch (URISyntaxException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return u;
    }

    public Odps getOdps() {
        return this.odps;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public TunnelRetryHandler.RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public RestClient.RetryLogger getRetryLogger() {
        return this.retryLogger;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    public boolean availableQuotaName() {
        return !StringUtils.isEmpty((String)this.quotaName);
    }

    public RestClient newRestClient(String projectName) throws TunnelException {
        RestClient odpsServiceClient = this.odps.clone().getRestClient();
        odpsServiceClient.setReadTimeout(this.getSocketTimeout());
        odpsServiceClient.setConnectTimeout(this.getSocketConnectTimeout());
        odpsServiceClient.setRetryTimes(this.getSocketRetryTimes());
        if (StringUtils.isNullOrEmpty((String)this.odps.getTunnelEndpoint())) {
            odpsServiceClient.setEndpoint(this.getEndpoint(projectName).toString());
        } else {
            odpsServiceClient.setEndpoint(this.odps.getTunnelEndpoint());
        }
        return odpsServiceClient;
    }

    public Builder toBuilder() {
        return new Builder(this.odps).withQuotaName(this.quotaName).withCompressOptions(this.compressOption).withRetryPolicy(this.retryPolicy).withRetryLogger(this.retryLogger);
    }

    public static class Builder {
        private final Odps odps;
        private String quotaName = "";
        private List<String> tags;
        private CompressOption compressOption = new CompressOption();
        private TunnelRetryHandler.RetryPolicy retryPolicy;
        private RestClient.RetryLogger retryLogger;

        private Builder(Odps odps) {
            this.odps = odps;
        }

        public Builder withQuotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public Builder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withCompressOptions(CompressOption compressOption) {
            this.compressOption = compressOption;
            return this;
        }

        public Builder withRetryPolicy(TunnelRetryHandler.RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder withRetryLogger(RestClient.RetryLogger retryLogger) {
            this.retryLogger = retryLogger;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

