/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.accessor;

import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.ValueVector;

public class ArrowDecimalExtensionAccessor
extends ArrowVectorAccessor {
    protected final FixedSizeBinaryVector decimalVector;

    public ArrowDecimalExtensionAccessor(FixedSizeBinaryVector decimalVector) {
        super((ValueVector)decimalVector);
        this.decimalVector = decimalVector;
    }

    public BigDecimal getDecimal(int rowId) {
        try {
            int num;
            int j;
            byte[] val = this.decimalVector.get(rowId);
            ByteBuffer buffer = ByteBuffer.wrap(val);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte mSign = buffer.get(1);
            int mIntg = buffer.get(2);
            int mFrac = buffer.get(3);
            StringBuilder decimalBuilder = new StringBuilder();
            if (mSign > 0) {
                decimalBuilder.append("-");
            }
            for (j = mIntg; j > 0; --j) {
                num = buffer.getInt(8 + j * 4);
                if (j == mIntg) {
                    decimalBuilder.append(num);
                    continue;
                }
                decimalBuilder.append(String.format("%09d", num));
            }
            decimalBuilder.append(".");
            for (j = 0; j < mFrac; ++j) {
                num = buffer.getInt(8 - 4 * j);
                decimalBuilder.append(String.format("%09d", num));
            }
            return new BigDecimal(new BigDecimal(decimalBuilder.toString()).stripTrailingZeros().toPlainString());
        }
        catch (Exception e) {
            return null;
        }
    }
}

