/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.MethodName;
import com.aliyun.odps.simpleframework.xml.core.MethodPart;
import com.aliyun.odps.simpleframework.xml.core.MethodType;
import com.aliyun.odps.simpleframework.xml.core.Reflector;
import com.aliyun.odps.simpleframework.xml.util.Cache;
import com.aliyun.odps.simpleframework.xml.util.ConcurrentCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class GetPart
implements MethodPart {
    private final Cache<Annotation> cache = new ConcurrentCache<Annotation>();
    private final Annotation[] list;
    private final Annotation label;
    private final MethodType type;
    private final Method method;
    private final String name;

    public GetPart(MethodName method, Annotation label, Annotation[] list) {
        this.method = method.getMethod();
        this.name = method.getName();
        this.type = method.getType();
        this.label = label;
        this.list = list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.method.getReturnType();
    }

    @Override
    public Class getDependent() {
        return Reflector.getReturnDependent(this.method);
    }

    @Override
    public Class[] getDependents() {
        return Reflector.getReturnDependents(this.method);
    }

    @Override
    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        if (this.cache.isEmpty()) {
            for (Annotation entry : this.list) {
                Class<? extends Annotation> key = entry.annotationType();
                this.cache.cache(key, entry);
            }
        }
        return (T)this.cache.fetch(type);
    }

    @Override
    public MethodType getMethodType() {
        return this.type;
    }

    @Override
    public Method getMethod() {
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        return this.method;
    }

    @Override
    public String toString() {
        return this.method.toGenericString();
    }
}

