/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.DefaultType;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementArray;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.ElementListUnion;
import com.aliyun.odps.simpleframework.xml.ElementMap;
import com.aliyun.odps.simpleframework.xml.ElementMapUnion;
import com.aliyun.odps.simpleframework.xml.ElementUnion;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.Transient;
import com.aliyun.odps.simpleframework.xml.Version;
import com.aliyun.odps.simpleframework.xml.core.AnnotationFactory;
import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.ContactList;
import com.aliyun.odps.simpleframework.xml.core.ContactMap;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.FieldContact;
import com.aliyun.odps.simpleframework.xml.core.FieldDetail;
import com.aliyun.odps.simpleframework.xml.core.Reflector;
import com.aliyun.odps.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

class FieldScanner
extends ContactList {
    private final AnnotationFactory factory;
    private final ContactMap done;
    private final Support support;

    public FieldScanner(Detail detail, Support support) throws Exception {
        this.factory = new AnnotationFactory(detail, support);
        this.done = new ContactMap();
        this.support = support;
        this.scan(detail);
    }

    private void scan(Detail detail) throws Exception {
        DefaultType override = detail.getOverride();
        DefaultType access = detail.getAccess();
        Class base = detail.getSuper();
        if (base != null) {
            this.extend(base, override);
        }
        this.extract(detail, access);
        this.extract(detail);
        this.build();
    }

    private void extend(Class base, DefaultType access) throws Exception {
        ContactList list = this.support.getFields(base, access);
        if (list != null) {
            this.addAll(list);
        }
    }

    private void extract(Detail detail) {
        List<FieldDetail> fields = detail.getFields();
        for (FieldDetail entry : fields) {
            Annotation[] list = entry.getAnnotations();
            Field field = entry.getField();
            for (Annotation label : list) {
                this.scan(field, label, list);
            }
        }
    }

    private void extract(Detail detail, DefaultType access) throws Exception {
        List<FieldDetail> fields = detail.getFields();
        if (access == DefaultType.FIELD) {
            for (FieldDetail entry : fields) {
                Annotation[] list = entry.getAnnotations();
                Field field = entry.getField();
                Class<?> real = field.getType();
                if (this.isStatic(field) || this.isTransient(field)) continue;
                this.process(field, real, list);
            }
        }
    }

    private void scan(Field field, Annotation label, Annotation[] list) {
        if (label instanceof Attribute) {
            this.process(field, label, list);
        }
        if (label instanceof ElementUnion) {
            this.process(field, label, list);
        }
        if (label instanceof ElementListUnion) {
            this.process(field, label, list);
        }
        if (label instanceof ElementMapUnion) {
            this.process(field, label, list);
        }
        if (label instanceof ElementList) {
            this.process(field, label, list);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, list);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, list);
        }
        if (label instanceof Element) {
            this.process(field, label, list);
        }
        if (label instanceof Version) {
            this.process(field, label, list);
        }
        if (label instanceof Text) {
            this.process(field, label, list);
        }
        if (label instanceof Transient) {
            this.remove(field, label);
        }
    }

    private void process(Field field, Class type, Annotation[] list) throws Exception {
        Class[] dependents = Reflector.getDependents(field);
        Annotation label = this.factory.getInstance(type, dependents);
        if (label != null) {
            this.process(field, label, list);
        }
    }

    private void process(Field field, Annotation label, Annotation[] list) {
        FieldContact contact = new FieldContact(field, label, list);
        FieldKey key = new FieldKey(field);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.insert(key, contact);
    }

    private void insert(Object key, Contact contact) {
        Contact existing = (Contact)this.done.remove(key);
        if (existing != null && this.isText(contact)) {
            contact = existing;
        }
        this.done.put(key, contact);
    }

    private boolean isText(Contact contact) {
        Annotation label = contact.getAnnotation();
        return label instanceof Text;
    }

    private void remove(Field field, Annotation label) {
        this.done.remove(new FieldKey(field));
    }

    private void build() {
        for (Contact contact : this.done) {
            this.add(contact);
        }
    }

    private boolean isStatic(Field field) {
        int modifier = field.getModifiers();
        return Modifier.isStatic(modifier);
    }

    private boolean isTransient(Field field) {
        int modifier = field.getModifiers();
        return Modifier.isTransient(modifier);
    }

    private static class FieldKey {
        private final Class type;
        private final String name;

        public FieldKey(Field field) {
            this.type = field.getDeclaringClass();
            this.name = field.getName();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object value) {
            if (value instanceof FieldKey) {
                return this.equals((FieldKey)value);
            }
            return false;
        }

        private boolean equals(FieldKey other) {
            if (other.type != this.type) {
                return false;
            }
            return other.name.equals(this.name);
        }
    }
}

