/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util.backoff;

import com.aliyun.odps.commons.util.backoff.BackOffStrategy;

public class FixedBackOffStrategy
extends BackOffStrategy {
    private long interval;
    private long startTime = -1L;

    public FixedBackOffStrategy(long initInterval) {
        super(initInterval);
        this.interval = initInterval;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public long next() {
        if (this.startTime < 0L) {
            throw new IllegalArgumentException("Please set start time at first.");
        }
        long lost = System.currentTimeMillis() - this.startTime;
        if (lost >= 0L) {
            long left = this.interval * 1000L - lost;
            return left > 0L ? left : 0L;
        }
        throw new IllegalArgumentException(String.format("FixedBackOffStrategy get backoff time error, start time (%s) is bigger than current time (%s)", this.startTime, lost + this.startTime));
    }

    @Override
    public void reset() {
    }
}

