/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Classification;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Tag;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Tags
implements Iterable<Tag> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Tag.TagModel.class, (Object)new Tag.TagModelSerializer()).registerTypeAdapter(Tag.TagModel.class, (Object)new Tag.TagModelDeserializer()).create();
    private Odps odps;
    private Classification classification;
    private RestClient client;

    Tags(Odps odps, Classification classification) {
        this.classification = Objects.requireNonNull(classification);
        this.odps = Objects.requireNonNull(odps);
        this.client = odps.getRestClient();
    }

    public void create(Tag tag, boolean ifNotExists) throws OdpsException {
        JsonObject root = new JsonObject();
        root.add("TagInput", GSON.toJsonTree((Object)tag.model));
        root.addProperty("IfNotExists", Boolean.valueOf(ifNotExists));
        String resource = ResourceBuilder.buildTagsResource(this.classification.getProject(), this.classification.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String body = GSON.toJson((JsonElement)root);
        this.client.request(resource, "POST", null, headers, body.getBytes());
    }

    public void create(TagBuilder tagBuilder, boolean ifNotExists) throws OdpsException {
        Objects.requireNonNull(tagBuilder);
        Tag tag = tagBuilder.build();
        this.create(tag, ifNotExists);
    }

    public void update(Tag tag) throws OdpsException {
        Objects.requireNonNull(tag);
        JsonObject root = new JsonObject();
        root.add("UpdateTagInput", GSON.toJsonTree((Object)tag.model));
        String resource = ResourceBuilder.buildTagResource(this.classification.getProject(), this.classification.getName(), tag.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String body = GSON.toJson((JsonElement)root);
        this.client.request(resource, "PUT", null, headers, body.getBytes());
    }

    public boolean exists(String name) throws OdpsException {
        try {
            Tag tag = this.get(name);
            tag.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public Tag get(String name) {
        Tag.TagModel model = new Tag.TagModel();
        model.project = this.classification.getProject();
        model.classification = this.classification.getName();
        model.name = Objects.requireNonNull(name);
        return new Tag(model, this.odps);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new TagIterator(this.classification.getProject(), this.classification.getName());
    }

    public static class TagBuilder {
        Classification classification;
        String name;
        Map<String, String> attributes = new HashMap<String, String>();
        String policy;

        public TagBuilder(Classification classification, String name) {
            this.classification = Objects.requireNonNull(classification);
            this.name = Objects.requireNonNull(name);
        }

        public TagBuilder attribute(String attributeName, String attribute) {
            if (!this.classification.getAttributeDefinitions().containsKey(attributeName)) {
                throw new IllegalArgumentException("Attribute name not defined in this classification: " + attributeName);
            }
            this.attributes.put(Objects.requireNonNull(attributeName), Objects.requireNonNull(attribute));
            return this;
        }

        public TagBuilder policy(String policy) {
            this.policy = Objects.requireNonNull(policy);
            return this;
        }

        public Tag build() {
            return new Tag(this);
        }
    }

    private class TagIterator
    extends ListIterator<Tag> {
        Map<String, String> params = new HashMap<String, String>();
        private String project;
        private String classification;

        TagIterator(String project, String classification) {
            this.project = Objects.requireNonNull(project);
            this.classification = Objects.requireNonNull(classification);
        }

        @Override
        protected List<Tag> list() {
            LinkedList<Tag> tags = new LinkedList<Tag>();
            String lastMarker = this.params.get("NextPageToken");
            if (this.params.containsKey("NextPageToken") && lastMarker.isEmpty()) {
                return null;
            }
            String resource = ResourceBuilder.buildTagsResource(this.project, this.classification);
            try {
                Response resp = Tags.this.client.request(resource, "GET", this.params, null, null);
                String respBody = new String(resp.getBody(), StandardCharsets.UTF_8);
                JsonParser parser = new JsonParser();
                JsonElement parsedRespBody = parser.parse(respBody);
                if (!parsedRespBody.isJsonObject()) {
                    throw new JsonParseException("Expect a JsonObject, but got: " + respBody);
                }
                JsonObject jsonObject = parsedRespBody.getAsJsonObject();
                if (jsonObject.has("NextPageToken")) {
                    this.params.put("NextPageToken", jsonObject.get("NextPageToken").getAsString());
                }
                if (jsonObject.has("Tags")) {
                    if (!jsonObject.get("Tags").isJsonArray()) {
                        throw new JsonParseException("Expect a JsonArray, but got: " + jsonObject.get("Tags").toString());
                    }
                    JsonArray tagElements = jsonObject.get("Tags").getAsJsonArray();
                    for (JsonElement element : tagElements) {
                        Tag.TagModel model = (Tag.TagModel)GSON.fromJson(element, Tag.TagModel.class);
                        tags.add(new Tag(model, Tags.this.odps));
                    }
                }
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return tags;
        }
    }
}

