/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Session;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Sessions
implements Iterable<Session.SessionItem> {
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private RestClient client;
    private Odps odps;

    public Sessions(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    @Override
    public Iterator<Session.SessionItem> iterator() {
        return new SessionListIterator();
    }

    public Iterable<Session.SessionItem> iterable() {
        return new Iterable<Session.SessionItem>(){

            @Override
            public Iterator<Session.SessionItem> iterator() {
                return new SessionListIterator();
            }
        };
    }

    private class SessionListIterator
    extends ListIterator<Session.SessionItem> {
        private boolean inited = false;

        private SessionListIterator() {
        }

        @Override
        protected List<Session.SessionItem> list() {
            if (this.inited) {
                return null;
            }
            ArrayList<Session.SessionItem> list = new ArrayList<Session.SessionItem>();
            try {
                Response resp = Sessions.this.client.request(ResourceBuilder.buildSessionsResource(Sessions.this.odps.getDefaultProject()), "GET", null, null, null);
                Type type = new TypeToken<Map<String, Session.SessionItem>>(){}.getType();
                String body = new String(resp.getBody());
                Map sessions = (Map)gson.fromJson(body, type);
                for (Map.Entry entry : sessions.entrySet()) {
                    list.add((Session.SessionItem)entry.getValue());
                }
                this.inited = true;
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return list;
        }
    }
}

