/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Quota;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Quotas
implements Iterable<Quota> {
    private Odps odps;

    Quotas(Odps odps) {
        if (odps == null) {
            throw new IllegalArgumentException("Argument 'odps' cannot be null");
        }
        this.odps = odps;
    }

    public Quota get(String regionId, String name) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Argument 'name' cannot be null or empty");
        }
        return new Quota(this.odps, regionId, name);
    }

    public Quota getWlmQuota(String project, String name) throws OdpsException {
        return this.getWlmQuota(project, name, null);
    }

    public Quota getWlmQuota(String project, String name, String regionId) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Argument 'name' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)project)) {
            throw new IllegalArgumentException("Argument 'project' cannot be null or empty");
        }
        String tenantId = this.odps.projects().get(project).getTenantId();
        return new Quota(this.odps, regionId, name, tenantId);
    }

    public Quota get(String name) {
        return this.get(null, name);
    }

    public boolean exists(String regionId, String name) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Argument 'name' cannot be null or empty");
        }
        try {
            new Quota(this.odps, regionId, name).reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public boolean exists(String name) throws OdpsException {
        return this.exists(null, name);
    }

    public Iterator<Quota> iterator(String regionId) {
        return new QuotaListIterator(this.odps, regionId);
    }

    @Override
    public Iterator<Quota> iterator() {
        return this.iterator(null);
    }

    private static class QuotaListIterator
    extends ListIterator<Quota> {
        private Odps odps;
        private Map<String, String> params = new HashMap<String, String>();

        QuotaListIterator(Odps odps, String regionId) {
            this.odps = odps;
            this.params.put("version", "wlm");
            this.params.put("project", odps.getDefaultProject());
            if (regionId != null) {
                this.params.put("region", regionId);
            }
        }

        @Override
        protected List<Quota> list() {
            ArrayList<Quota> quotas = new ArrayList<Quota>();
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && StringUtils.isNullOrEmpty((String)lastMarker)) {
                return null;
            }
            try {
                ListQuotasResponse resp = this.odps.getRestClient().request(ListQuotasResponse.class, "/quotas", "GET", this.params);
                for (Quota.QuotaModel model : resp.quotas) {
                    Quota quota = new Quota(this.odps, model);
                    quotas.add(quota);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return quotas;
        }
    }

    @Root(name="Quotas", strict=false)
    private static class ListQuotasResponse {
        @ElementList(entry="Quota", inline=true, required=false)
        private List<Quota.QuotaModel> quotas = new ArrayList<Quota.QuotaModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListQuotasResponse() {
        }
    }
}

