/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.SimpleStructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.Objects;

class SimpleArrayTypeInfo
implements ArrayTypeInfo {
    private static final long serialVersionUID = 1L;
    private final TypeInfo valueType;

    SimpleArrayTypeInfo(TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Invalid element type.");
        }
        this.valueType = typeInfo;
    }

    @Override
    public TypeInfo getElementTypeInfo() {
        return this.valueType;
    }

    @Override
    public OdpsType getOdpsType() {
        return OdpsType.ARRAY;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleArrayTypeInfo that = (SimpleArrayTypeInfo)o;
        return Objects.equals(this.valueType, that.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.valueType);
    }

    @Override
    public String getTypeName() {
        return this.getTypeName(false);
    }

    @Override
    public String getTypeName(boolean quote) {
        if (quote && this.valueType instanceof SimpleStructTypeInfo) {
            return this.getOdpsType().name() + "<" + ((SimpleStructTypeInfo)this.valueType).getTypeName(true) + ">";
        }
        return this.getOdpsType().name() + "<" + this.valueType.getTypeName() + ">";
    }
}

