/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.io;

import com.aliyun.odps.io.Writable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BitMapWritable
implements Writable {
    private byte[] bits;
    private int size;

    public BitMapWritable(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        int arraySize = size / 8;
        if (size % 8 != 0) {
            ++arraySize;
        }
        this.bits = new byte[arraySize];
        this.size = arraySize;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.bits);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        in.readFully(this.bits);
    }

    public boolean get(int index) {
        int i = index / 8;
        byte flag = this.bits[i];
        int j = index % 8;
        int ret = flag >>> j & 1;
        return ret != 0;
    }

    public void set(int index, boolean flag) {
        int i = index / 8;
        int j = index % 8;
        int mask = flag ? 1 : 0;
        this.bits[i] = (byte)(this.bits[i] | (mask <<= j));
    }

    public int getDataSize() {
        return this.size;
    }
}

