/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import com.aliyun.core.http.Header;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.StringUtils;
import java.util.Collections;

public class ClientOptions {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'productId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'productId' cannot contain spaces.";
    private final ClientLogger logger = new ClientLogger(ClientOptions.class);
    private Iterable<Header> headers;
    private String productId;

    public String getProductId() {
        return this.productId;
    }

    public ClientOptions setProductId(String productId) {
        if (StringUtils.isEmpty(productId)) {
            this.productId = productId;
        } else {
            if (productId.length() > 24) {
                throw this.logger.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (productId.contains(" ")) {
                throw this.logger.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
            this.productId = productId;
        }
        return this;
    }

    public ClientOptions setHeaders(Iterable<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Iterable<Header> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers;
    }
}

