/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.boot.rabbitmq.processor;

import com.sofa.alipay.tracer.plugins.rabbitmq.interceptor.SofaTracerConsumeInterceptor;
import java.lang.reflect.Field;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class SofaTracerRabbitMqBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SimpleRabbitListenerContainerFactory) {
            SimpleRabbitListenerContainerFactory factory = (SimpleRabbitListenerContainerFactory)bean;
            this.registerTracingInterceptor((AbstractRabbitListenerContainerFactory)factory);
        } else if (bean instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer container = (SimpleMessageListenerContainer)bean;
            this.registerTracingInterceptor((AbstractMessageListenerContainer)container);
        } else if (bean instanceof DirectRabbitListenerContainerFactory) {
            DirectRabbitListenerContainerFactory factory = (DirectRabbitListenerContainerFactory)bean;
            this.registerTracingInterceptor((AbstractRabbitListenerContainerFactory)factory);
        } else if (bean instanceof DirectMessageListenerContainer) {
            DirectMessageListenerContainer container = (DirectMessageListenerContainer)bean;
            this.registerTracingInterceptor((AbstractMessageListenerContainer)container);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void registerTracingInterceptor(AbstractRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        Advice[] adviceChainWithTracing = this.getAdviceChainOrAddInterceptorToChain(chain);
        factory.setAdviceChain(adviceChainWithTracing);
    }

    private void registerTracingInterceptor(AbstractMessageListenerContainer container) {
        Field adviceChainField = ReflectionUtils.findField(AbstractMessageListenerContainer.class, (String)"adviceChain");
        ReflectionUtils.makeAccessible((Field)adviceChainField);
        Advice[] chain = (Advice[])ReflectionUtils.getField((Field)adviceChainField, (Object)container);
        Advice[] adviceChainWithTracing = this.getAdviceChainOrAddInterceptorToChain(chain);
        container.setAdviceChain(adviceChainWithTracing);
    }

    private Advice[] getAdviceChainOrAddInterceptorToChain(Advice ... existingAdviceChain) {
        if (existingAdviceChain == null) {
            return new Advice[]{new SofaTracerConsumeInterceptor()};
        }
        for (Advice advice : existingAdviceChain) {
            if (!(advice instanceof SofaTracerConsumeInterceptor)) continue;
            return existingAdviceChain;
        }
        Advice[] newChain = new Advice[existingAdviceChain.length + 1];
        System.arraycopy(existingAdviceChain, 0, newChain, 0, existingAdviceChain.length);
        newChain[existingAdviceChain.length] = new SofaTracerConsumeInterceptor();
        return newChain;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

