/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.runner;

import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.common.DelegateArkContainer;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;

public class JUnitExecutionListener
extends RunListener {
    private static final String ARK_JUNIT4_RUNNER = "com.alipay.sofa.ark.support.runner.ArkJUnit4Runner";
    private static final String ARK_BOOT_RUNNER = "com.alipay.sofa.ark.springboot.runner.ArkBootRunner";
    private static final Object LOCK = new Object();
    private static volatile RunListener singleton;

    private JUnitExecutionListener() {
    }

    public void testStarted(Description description) throws Exception {
        if (this.isTestOnArkContainer(description)) {
            ClassLoaderUtils.pushContextClassLoader((ClassLoader)DelegateArkContainer.getTestClassLoader());
        } else {
            ClassLoaderUtils.pushContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
        }
        super.testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        super.testStarted(description);
        ClassLoaderUtils.pushContextClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
    }

    protected boolean isTestOnArkContainer(Description description) {
        RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
        if (runWith == null) {
            return false;
        }
        Class runnerClass = runWith.value();
        String className = runnerClass.getName();
        return ARK_JUNIT4_RUNNER.equals(className) || ARK_BOOT_RUNNER.equals(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunListener getRunListener() {
        if (singleton == null) {
            Object object = LOCK;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new JUnitExecutionListener();
                }
            }
        }
        return singleton;
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        DelegateArkContainer.shutdown();
    }
}

