/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.common;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderHook;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderService;
import com.alipay.sofa.ark.spi.service.extension.Extension;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

@Extension(value="biz-classloader-hook")
public class DelegateToMasterBizClassLoaderHook
implements ClassLoaderHook<Biz> {
    public Class<?> preFindClass(String name, ClassLoaderService classLoaderService, Biz biz) throws ClassNotFoundException {
        return null;
    }

    public Class<?> postFindClass(String name, ClassLoaderService classLoaderService, Biz biz) throws ClassNotFoundException {
        ClassLoader bizClassLoader = ArkClient.getMasterBiz().getBizClassLoader();
        if (biz == null || biz.getBizClassLoader() == bizClassLoader) {
            return null;
        }
        Class<?> clazz = bizClassLoader.loadClass(name);
        if (clazz != null) {
            String location = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
            if (biz.isDeclared(location)) {
                return clazz;
            }
            try {
                Enumeration<URL> urls = bizClassLoader.getResources(name.replace('.', '/') + ".class");
                while (urls.hasMoreElements()) {
                    URL resourceUrl = urls.nextElement();
                    if (!biz.isDeclared(resourceUrl)) continue;
                    ArkLoggerFactory.getDefaultLogger().warn(String.format("find class %s from %s in multiple dependencies.", name, resourceUrl.getFile()));
                    return clazz;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public URL preFindResource(String name, ClassLoaderService classLoaderService, Biz biz) {
        return null;
    }

    public URL postFindResource(String name, ClassLoaderService classLoaderService, Biz biz) {
        if (biz == null || !biz.isDeclaredMode() && this.shouldSkip(name)) {
            return null;
        }
        ClassLoader bizClassLoader = ArkClient.getMasterBiz().getBizClassLoader();
        if (biz.getBizClassLoader() == bizClassLoader) {
            return null;
        }
        try {
            URL resourceUrl = bizClassLoader.getResource(name);
            if (biz.isDeclared(resourceUrl)) {
                return resourceUrl;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Enumeration<URL> preFindResources(String name, ClassLoaderService classLoaderService, Biz biz) throws IOException {
        return null;
    }

    public Enumeration<URL> postFindResources(String name, ClassLoaderService classLoaderService, Biz biz) throws IOException {
        if (biz == null || !biz.isDeclaredMode() && this.shouldSkip(name)) {
            return null;
        }
        ClassLoader bizClassLoader = ArkClient.getMasterBiz().getBizClassLoader();
        if (biz.getBizClassLoader() == bizClassLoader) {
            return null;
        }
        try {
            Enumeration<URL> resourceUrls = bizClassLoader.getResources(name);
            ArrayList<URL> matchedResourceUrls = new ArrayList<URL>();
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                if (!biz.isDeclared(resourceUrl)) continue;
                matchedResourceUrls.add(resourceUrl);
            }
            return Collections.enumeration(matchedResourceUrls);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean shouldSkip(String resourceName) {
        return !resourceName.endsWith(".class");
    }
}

