/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.common;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.startup.SofaArkBootstrap;
import java.lang.reflect.Method;

public class DelegateArkContainer {
    private static final String TEST_HELPER = "com.alipay.sofa.ark.container.test.TestHelper";
    private static final String CREATE_TEST_CLASSLOADER = "createTestClassLoader";
    private static final String STOP_CONTAINER = "stop";
    private static Method CREATE_TEST_CLASSLOADER_METHOD;
    private static Method STOP_CONTAINER_METHOD;
    private static volatile Object arkContainer;
    private static Object testHelper;
    private static volatile ClassLoader testClassLoader;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(Class testClass) {
        if (arkContainer == null) {
            Object object = LOCK;
            synchronized (object) {
                if (arkContainer == null) {
                    Object container = SofaArkBootstrap.prepareContainerForTest(testClass);
                    DelegateArkContainer.wrapping(container);
                    arkContainer = container;
                }
            }
        }
        ClassLoaderUtils.pushContextClassLoader((ClassLoader)DelegateArkContainer.getTestClassLoader());
    }

    protected static void wrapping(Object container) {
        AssertUtils.assertNotNull((Object)container, (String)"Ark Container must be not null.");
        try {
            Class<?> testHelperClass = container.getClass().getClassLoader().loadClass(TEST_HELPER);
            testHelper = testHelperClass.getConstructor(Object.class).newInstance(container);
            CREATE_TEST_CLASSLOADER_METHOD = testHelperClass.getMethod(CREATE_TEST_CLASSLOADER, new Class[0]);
            STOP_CONTAINER_METHOD = container.getClass().getMethod(STOP_CONTAINER, new Class[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getTestClassLoader() {
        if (testClassLoader == null) {
            Object object = LOCK;
            synchronized (object) {
                if (testClassLoader == null) {
                    try {
                        testClassLoader = (ClassLoader)CREATE_TEST_CLASSLOADER_METHOD.invoke(testHelper, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        return testClassLoader;
    }

    public static boolean isStarted() {
        return arkContainer != null;
    }

    public static Class loadClass(String name) {
        try {
            return DelegateArkContainer.getTestClassLoader().loadClass(name);
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
    }

    public static void shutdown() {
        if (arkContainer != null) {
            try {
                STOP_CONTAINER_METHOD.invoke(arkContainer, new Object[0]);
                arkContainer = null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static {
        LOCK = new Object();
    }
}

