/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.logging.initializer;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import com.alipay.sofa.boot.logging.filter.DefaultLogbackFilterGenerator;
import com.alipay.sofa.boot.logging.util.SystemPropertiesGetter;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.spi.LogbackReInitializer;
import com.alipay.sofa.common.utils.ClassUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Marker;

public class DefaultLogbackReInitializer
implements LogbackReInitializer {
    private static final String BRIDGE_HANDLER = "org.slf4j.bridge.SLF4JBridgeHandler";

    public void reInitialize(final SpaceId spaceId, LoggerContext loggerContext, final Properties properties, URL confFile) {
        if (this.isAlreadyReInitialized(loggerContext)) {
            return;
        }
        this.stopAndReset(loggerContext);
        loggerContext.getTurboFilterList().remove((Object)DefaultLogbackFilterGenerator.FILTER);
        this.markAsReInitialized(loggerContext);
        this.initProperties(loggerContext, properties);
        if (this.isConsoleAppenderOpen(spaceId.getSpaceName(), properties)) {
            final ConsoleAppender appender = this.consoleAppender(loggerContext, properties);
            loggerContext.addTurboFilter(new TurboFilter(){

                public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
                    if (!logger.isAttached((Appender)appender)) {
                        logger.detachAndStopAllAppenders();
                        logger.setLevel(DefaultLogbackReInitializer.this.getConsoleLevel(spaceId.getSpaceName(), properties));
                        logger.addAppender((Appender)appender);
                    }
                    return FilterReply.NEUTRAL;
                }
            });
        } else {
            try {
                new ContextInitializer(loggerContext).configureByResource(confFile);
            }
            catch (JoranException e) {
                throw new IllegalStateException("Logback loggerSpaceFactory re-build error", e);
            }
        }
    }

    private Level getConsoleLevel(String spaceId, Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        String level = propertiesGetter.getProperty("sofa.middleware.log.console.level");
        String defaultLevel = StringUtil.isBlank((String)level) ? "INFO" : level;
        level = propertiesGetter.getProperty(String.format("sofa.middleware.log.%s.console.level", spaceId), defaultLevel);
        return Level.toLevel((String)level, (Level)Level.INFO);
    }

    private ConsoleAppender consoleAppender(LoggerContext loggerContext, Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = propertiesGetter.getProperty("sofa.middleware.log.console.logback.pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p ${PID:- } --- [%15.15t] %-40.40logger{39} : %m%n");
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)loggerContext));
        encoder.setContext((Context)loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.setName("CONSOLE");
        appender.start();
        return appender;
    }

    private boolean isConsoleAppenderOpen(String spaceId, Properties properties) {
        SystemPropertiesGetter propertiesGetter = new SystemPropertiesGetter(properties);
        String value = propertiesGetter.getProperty(String.format("sofa.middleware.log.%s.console", spaceId));
        if (StringUtil.isBlank((String)value)) {
            return "true".equalsIgnoreCase(propertiesGetter.getProperty("sofa.middleware.log.console"));
        }
        return "true".equalsIgnoreCase(value);
    }

    private void markAsReInitialized(LoggerContext loggerContext) {
        loggerContext.putObject(DefaultLogbackReInitializer.class.getCanonicalName(), new Object());
    }

    private boolean isAlreadyReInitialized(LoggerContext loggerContext) {
        return loggerContext.getObject(DefaultLogbackReInitializer.class.getCanonicalName()) != null;
    }

    private void stopAndReset(LoggerContext loggerContext) {
        loggerContext.stop();
        loggerContext.reset();
        if (this.isBridgeHandlerAvailable()) {
            this.addLevelChangePropagator(loggerContext);
        }
    }

    protected final boolean isBridgeHandlerAvailable() {
        return ClassUtil.isPresent((String)BRIDGE_HANDLER, (ClassLoader)this.getClass().getClassLoader());
    }

    private void addLevelChangePropagator(LoggerContext loggerContext) {
        LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
        levelChangePropagator.setResetJUL(true);
        levelChangePropagator.setContext((Context)loggerContext);
        loggerContext.addListener((LoggerContextListener)levelChangePropagator);
    }

    private void initProperties(LoggerContext loggerContext, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String originValue = (String)entry.getValue();
            String value = System.getProperty(key, originValue);
            loggerContext.putProperty(key, value);
        }
    }
}

