/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.log;

import com.alipay.remoting.util.StringUtils;
import com.alipay.sofa.common.log.LoggerSpaceManager;
import java.io.File;
import org.slf4j.Logger;

public class BoltLoggerFactory {
    public static final String BOLT_LOG_SPACE_PROPERTY = "bolt.log.space";
    private static String BOLT_LOG_SPACE;
    private static final String LOG_PATH = "logging.path";
    private static final String LOG_PATH_DEFAULT;
    private static final String CLIENT_LOG_LEVEL = "com.alipay.remoting.client.log.level";
    private static final String CLIENT_LOG_LEVEL_DEFAULT = "INFO";
    private static final String CLIENT_LOG_ENCODE = "com.alipay.remoting.client.log.encode";
    private static final String COMMON_ENCODE = "file.encoding";
    private static final String CLIENT_LOG_ENCODE_DEFAULT = "UTF-8";

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            return BoltLoggerFactory.getLogger("");
        }
        return BoltLoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        if (name == null || name.isEmpty()) {
            return LoggerSpaceManager.getLoggerBySpace((String)"", (String)BOLT_LOG_SPACE);
        }
        return LoggerSpaceManager.getLoggerBySpace((String)name, (String)BOLT_LOG_SPACE);
    }

    static {
        String commonEncode;
        String logLevel;
        String logPath;
        BOLT_LOG_SPACE = "com.alipay.remoting";
        LOG_PATH_DEFAULT = System.getProperty("user.home") + File.separator + "logs";
        String logSpace = System.getProperty(BOLT_LOG_SPACE_PROPERTY);
        if (null != logSpace && !logSpace.isEmpty()) {
            BOLT_LOG_SPACE = logSpace;
        }
        if (StringUtils.isBlank(logPath = System.getProperty(LOG_PATH))) {
            System.setProperty(LOG_PATH, LOG_PATH_DEFAULT);
        }
        if (StringUtils.isBlank(logLevel = System.getProperty(CLIENT_LOG_LEVEL))) {
            System.setProperty(CLIENT_LOG_LEVEL, CLIENT_LOG_LEVEL_DEFAULT);
        }
        if (StringUtils.isNotBlank(commonEncode = System.getProperty(COMMON_ENCODE))) {
            System.setProperty(CLIENT_LOG_ENCODE, commonEncode);
        } else {
            String logEncode = System.getProperty(CLIENT_LOG_ENCODE);
            if (StringUtils.isBlank(logEncode)) {
                System.setProperty(CLIENT_LOG_ENCODE, CLIENT_LOG_ENCODE_DEFAULT);
            }
        }
    }
}

