/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.encrypt.impl;

import com.alipay.api.AlipayApiErrorEnum;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.codec.Base64;
import com.alipay.api.internal.util.encrypt.Encrypt;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryptV2
implements Encrypt {
    private static final String SLASH = "/";
    private static final String alg = "AES";
    private static final String mode = "CBC";
    private static final String padding = "PKCS5Padding";
    private static final int ivSize = 16;
    private final String fullCipherName;

    public AesEncryptV2() {
        this.fullCipherName = "AES/CBC/PKCS5Padding";
    }

    @Override
    public String encrypt(String content, String key, String charset) throws AlipayApiException {
        try {
            Cipher cipher = Cipher.getInstance(this.fullCipherName);
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decodeBase64(key.getBytes()), alg), ivParams);
            byte[] encryptedText = cipher.doFinal(content.getBytes(charset));
            byte[] ivAndEncryptedText = new byte[16 + encryptedText.length];
            System.arraycopy(iv, 0, ivAndEncryptedText, 0, 16);
            System.arraycopy(encryptedText, 0, ivAndEncryptedText, 16, encryptedText.length);
            return new String(Base64.encodeBase64(ivAndEncryptedText));
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.ENCRYPT_ASE_V2_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }

    @Override
    public String decrypt(String content, String key, String charset) throws AlipayApiException {
        try {
            byte[] ivAndEncryptedText = Base64.decodeBase64(content.getBytes());
            Cipher cipher = Cipher.getInstance(this.fullCipherName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivAndEncryptedText, 0, 16);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64(key.getBytes()), alg), ivParameterSpec);
            byte[] contentBytes = cipher.doFinal(ivAndEncryptedText, 16, ivAndEncryptedText.length - 16);
            return new String(contentBytes, charset);
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.DECRYPT_ASE_V2_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }
}

