/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.util;

import com.alipay.service.schema.exception.SchemaException;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final String DEFAULT_ENCODE = "UTF-8";
    public static String EGE = "http://xml.org/sax/features/external-general-entities";
    public static String EPE = "http://xml.org/sax/features/external-parameter-entities";
    public static String LED = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static Document newDocument() {
        Document doc = null;
        doc = DocumentHelper.createDocument();
        doc.setXMLEncoding(DEFAULT_ENCODE);
        return doc;
    }

    public static Document getDocument(File file) throws SchemaException {
        SAXReader reader = new SAXReader();
        reader.setEncoding(DEFAULT_ENCODE);
        Document doc = null;
        try {
            reader.setFeature(LED, false);
            reader.setFeature(EGE, false);
            reader.setFeature(EPE, false);
            doc = reader.read(file);
        }
        catch (DocumentException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        return doc;
    }

    public static Document getDocument(InputStream xml) throws SchemaException {
        SAXReader reader = new SAXReader();
        reader.setEncoding(DEFAULT_ENCODE);
        Document doc = null;
        try {
            reader.setFeature(LED, false);
            reader.setFeature(EGE, false);
            reader.setFeature(EPE, false);
            doc = reader.read(xml);
        }
        catch (DocumentException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        return doc;
    }

    public static Document getDocument(InputSource xml) throws SchemaException {
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            reader.setFeature(LED, false);
            reader.setFeature(EGE, false);
            reader.setFeature(EPE, false);
            doc = reader.read(xml);
        }
        catch (DocumentException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, (Throwable)e);
        }
        return doc;
    }

    public static Element createRootElement(String tagName) throws SchemaException {
        Document doc = XmlUtils.newDocument();
        Element root = DocumentHelper.createElement((String)tagName);
        doc.add(root);
        return root;
    }

    public static Element getRootElementFromStream(InputStream xml) throws SchemaException {
        return XmlUtils.getDocument(xml).getRootElement();
    }

    public static Element getRootElementFromFile(File xml) throws SchemaException {
        return XmlUtils.getDocument(xml).getRootElement();
    }

    public static Element getRootElementFromString(String payload) throws SchemaException {
        if (payload == null || payload.length() < 1) {
            throw new SchemaException(SchemaErrorEnum.XML_FORMAT_ERROR, "");
        }
        StringReader sr = new StringReader(XmlUtils.escapeXml(payload));
        InputSource source = new InputSource(sr);
        return XmlUtils.getDocument(source).getRootElement();
    }

    public static String escapeXml(String payload) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < payload.length(); ++i) {
            char c = payload.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String xmlToString(File file) throws SchemaException {
        return XmlUtils.getDocument(file).asXML();
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        List allNodes = parent.elements(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < allNodes.size(); ++i) {
            Element node = (Element)allNodes.get(i);
            if (!(node instanceof Element) || node.getParent() != parent) continue;
            elements.add(node);
        }
        return elements;
    }

    public static List<Element> getElements(Element parent, String tagName) {
        List allNodes = parent.elements();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < allNodes.size(); ++i) {
            Element node = (Element)allNodes.get(i);
            if (!(node instanceof Element)) continue;
            elements.add(node);
        }
        return elements;
    }

    public static Element getElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static Element getChildElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getChildElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static String getElementValue(Element parent, String tagName) {
        Element element = XmlUtils.getElement(parent, tagName);
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    public static String getElementValue(Element element) {
        if (!StringUtil.isEmpty(element.getText())) {
            return element.getText();
        }
        return null;
    }

    public static String getAttributeValue(Element current, String attrName) {
        return current.attributeValue(attrName);
    }

    public static Element appendElement(Element parent, String tagName) {
        return parent.addElement(tagName);
    }

    public static void appendElement(Element parent, Element child) {
        parent.add(child);
    }

    public static String nodeToString(Node node) throws SchemaException {
        return node.asXML();
    }

    public static String xmlToString(InputStream in) throws SchemaException {
        Element root = XmlUtils.getRootElementFromStream(in);
        return XmlUtils.nodeToString((Node)root);
    }
}

