/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.exception;

import com.alipay.service.schema.model.enums.SchemaErrorEnum;

public class SchemaException
extends Exception {
    private String errorCode;
    private String errorMessage;
    private String attributeId;

    public SchemaException(SchemaErrorEnum errorEnum) {
        super(errorEnum.getErrorMessage());
        this.errorCode = errorEnum.getErrorCode();
        this.errorMessage = errorEnum.getErrorMessage();
    }

    public SchemaException(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public SchemaException(SchemaErrorEnum errorCode, String attributeId) {
        super(errorCode.getErrorMessage());
        String msg = errorCode.getErrorMessage();
        if (attributeId != null && attributeId.length() != 0) {
            msg = msg + "At the filed which id is " + attributeId;
        }
        this.errorCode = errorCode.getErrorCode();
        this.errorMessage = msg;
        this.attributeId = attributeId;
    }

    public SchemaException(String errorCode, String errorMessage, String attributeId) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.attributeId = attributeId;
    }

    public SchemaException(SchemaErrorEnum errorCode, Throwable e) {
        super(errorCode.getErrorMessage(), e);
        this.errorCode = errorCode.getErrorCode();
        this.errorMessage = errorCode.getErrorMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }
}

