/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.ResultData;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CacheGetResult<V>
extends CacheResult {
    private volatile V value;
    private volatile CacheValueHolder<V> holder;
    public static final CacheGetResult NOT_EXISTS_WITHOUT_MSG = new CacheGetResult(CacheResultCode.NOT_EXISTS, null, null);
    public static final CacheGetResult EXPIRED_WITHOUT_MSG = new CacheGetResult(CacheResultCode.EXPIRED, null, null);

    public CacheGetResult(CacheResultCode resultCode, String message, CacheValueHolder<V> holder) {
        super(CompletableFuture.completedFuture(new ResultData(resultCode, message, holder)));
    }

    public CacheGetResult(CompletionStage<ResultData> future) {
        super(future);
    }

    public CacheGetResult(Throwable ex) {
        super(ex);
    }

    public V getValue() {
        this.waitForResult();
        return this.value;
    }

    @Override
    protected void fetchResultSuccess(ResultData resultData) {
        this.holder = (CacheValueHolder)resultData.getOriginData();
        this.value = CacheGetResult.unwrapValue(this.holder);
        super.fetchResultSuccess(resultData);
    }

    static Object unwrapValue(Object holder) {
        Object v = holder;
        while (v != null && v instanceof CacheValueHolder) {
            v = ((CacheValueHolder)v).getValue();
        }
        return v;
    }

    @Override
    protected void fetchResultFail(Throwable e) {
        this.value = null;
        super.fetchResultFail(e);
    }

    protected CacheValueHolder<V> getHolder() {
        this.waitForResult();
        return this.holder;
    }
}

