/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.store.helper;

import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.store.model.Event;
import org.apache.commons.lang.StringUtils;

public class CanalEventUtils {
    public static LogPosition min(LogPosition position1, LogPosition position2) {
        if (position1.getIdentity().equals((Object)position2.getIdentity())) {
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) > 0) {
                return position2;
            }
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) < 0) {
                return position1;
            }
            if (position1.getPostion().getPosition() > position2.getPostion().getPosition()) {
                return position2;
            }
            return position1;
        }
        if (position1.getPostion().getTimestamp() > position2.getPostion().getTimestamp()) {
            return position2;
        }
        return position1;
    }

    public static LogPosition createPosition(Event event) {
        EntryPosition position = new EntryPosition();
        position.setJournalName(event.getJournalName());
        position.setPosition(Long.valueOf(event.getPosition()));
        position.setTimestamp(Long.valueOf(event.getExecuteTime()));
        position.setServerId(Long.valueOf(event.getServerId()));
        position.setGtid(event.getGtid());
        LogPosition logPosition = new LogPosition();
        logPosition.setPostion(position);
        logPosition.setIdentity(event.getLogIdentity());
        return logPosition;
    }

    public static LogPosition createPosition(Event event, boolean included) {
        EntryPosition position = new EntryPosition();
        position.setJournalName(event.getJournalName());
        position.setPosition(Long.valueOf(event.getPosition()));
        position.setTimestamp(Long.valueOf(event.getExecuteTime()));
        position.setIncluded(included);
        position.setServerId(Long.valueOf(event.getServerId()));
        position.setGtid(event.getGtid());
        LogPosition logPosition = new LogPosition();
        logPosition.setPostion(position);
        logPosition.setIdentity(event.getLogIdentity());
        return logPosition;
    }

    public static boolean checkPosition(Event event, LogPosition logPosition) {
        boolean exactely;
        EntryPosition position = logPosition.getPostion();
        boolean result = position.getTimestamp().equals(event.getExecuteTime());
        boolean bl = exactely = StringUtils.isBlank((String)position.getJournalName()) && position.getPosition() == null;
        if (!exactely && (result &= position.getPosition().equals(event.getPosition()))) {
            result &= StringUtils.equals((String)event.getJournalName(), (String)position.getJournalName());
        }
        return result;
    }
}

