/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog;

import com.alibaba.otter.canal.parse.driver.mysql.packets.GTIDSet;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogContext;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.LogPosition;
import com.taobao.tddl.dbsync.binlog.event.AppendBlockLogEvent;
import com.taobao.tddl.dbsync.binlog.event.BeginLoadQueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.CreateFileLogEvent;
import com.taobao.tddl.dbsync.binlog.event.DeleteFileLogEvent;
import com.taobao.tddl.dbsync.binlog.event.DeleteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.ExecuteLoadLogEvent;
import com.taobao.tddl.dbsync.binlog.event.ExecuteLoadQueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.GtidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.HeartbeatLogEvent;
import com.taobao.tddl.dbsync.binlog.event.IgnorableLogEvent;
import com.taobao.tddl.dbsync.binlog.event.IncidentLogEvent;
import com.taobao.tddl.dbsync.binlog.event.IntvarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LoadLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import com.taobao.tddl.dbsync.binlog.event.PreviousGtidsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.QueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RandLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RotateLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsQueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.StartLogEventV3;
import com.taobao.tddl.dbsync.binlog.event.StopLogEvent;
import com.taobao.tddl.dbsync.binlog.event.TableMapLogEvent;
import com.taobao.tddl.dbsync.binlog.event.TransactionContextLogEvent;
import com.taobao.tddl.dbsync.binlog.event.TransactionPayloadLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UnknownLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UpdateRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UserVarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.ViewChangeEvent;
import com.taobao.tddl.dbsync.binlog.event.WriteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.XaPrepareLogEvent;
import com.taobao.tddl.dbsync.binlog.event.XidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.AnnotateRowsEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.BinlogCheckPointLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.MariaGtidListLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.MariaGtidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.StartEncryptionLogEvent;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LogDecoder {
    protected static final Log logger = LogFactory.getLog(LogDecoder.class);
    protected final BitSet handleSet = new BitSet(165);

    public LogDecoder() {
    }

    public LogDecoder(int fromIndex, int toIndex) {
        this.handleSet.set(fromIndex, toIndex);
    }

    public final void handle(int fromIndex, int toIndex) {
        this.handleSet.set(fromIndex, toIndex);
    }

    public final void handle(int flagIndex) {
        this.handleSet.set(flagIndex);
    }

    public LogEvent decode(LogBuffer buffer, LogContext context) throws IOException {
        LogHeader header;
        int len;
        int limit = buffer.limit();
        if (limit >= 19 && limit >= (len = (header = new LogHeader(buffer, context.getFormatDescription())).getEventLen())) {
            LogEvent event;
            if (this.handleSet.get(header.getType())) {
                buffer.limit(len);
                try {
                    event = LogDecoder.decode(buffer, header, context);
                }
                catch (IOException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Decoding " + LogEvent.getTypeName(header.getType()) + " failed from: " + context.getLogPosition()), (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    buffer.limit(limit);
                }
            } else {
                event = new UnknownLogEvent(header);
            }
            if (event != null) {
                event.getHeader().setLogFileName(context.getLogPosition().getFileName());
                event.setSemival(buffer.semival);
            }
            buffer.consume(len);
            return event;
        }
        buffer.rewind();
        return null;
    }

    public static LogEvent decode(LogBuffer buffer, LogHeader header, LogContext context) throws IOException {
        FormatDescriptionLogEvent descriptionEvent = context.getFormatDescription();
        LogPosition logPosition = context.getLogPosition();
        int checksumAlg = 255;
        checksumAlg = header.getType() != 15 ? descriptionEvent.header.getChecksumAlg() : header.getChecksumAlg();
        if (checksumAlg != 0 && checksumAlg != 255) {
            buffer.limit(header.getEventLen() - 4);
        }
        GTIDSet gtidSet = context.getGtidSet();
        LogEvent gtidLogEvent = context.getGtidLogEvent();
        switch (header.getType()) {
            case 2: {
                QueryLogEvent event = new QueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 16: {
                XidLogEvent event = new XidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 19: {
                TableMapLogEvent mapEvent = new TableMapLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                context.putTable(mapEvent);
                return mapEvent;
            }
            case 23: 
            case 30: {
                WriteRowsLogEvent event = new WriteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 24: 
            case 31: {
                UpdateRowsLogEvent event = new UpdateRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 25: 
            case 32: {
                DeleteRowsLogEvent event = new DeleteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 4: {
                RotateLogEvent event = new RotateLogEvent(header, buffer, descriptionEvent);
                logPosition = new LogPosition(event.getFilename(), event.getPosition());
                context.setLogPosition(logPosition);
                return event;
            }
            case 6: 
            case 12: {
                LoadLogEvent event = new LoadLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 7: {
                if (!logger.isWarnEnabled()) break;
                logger.warn((Object)("Skipping unsupported SLAVE_EVENT from: " + context.getLogPosition()));
                break;
            }
            case 8: {
                CreateFileLogEvent event = new CreateFileLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 9: {
                AppendBlockLogEvent event = new AppendBlockLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 11: {
                DeleteFileLogEvent event = new DeleteFileLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 10: {
                ExecuteLoadLogEvent event = new ExecuteLoadLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 1: {
                StartLogEventV3 event = new StartLogEventV3(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 3: {
                StopLogEvent event = new StopLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 5: {
                IntvarLogEvent event = new IntvarLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 13: {
                RandLogEvent event = new RandLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 14: {
                UserVarLogEvent event = new UserVarLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 15: {
                descriptionEvent = new FormatDescriptionLogEvent(header, buffer, descriptionEvent);
                context.setFormatDescription(descriptionEvent);
                return descriptionEvent;
            }
            case 20: {
                if (!logger.isWarnEnabled()) break;
                logger.warn((Object)("Skipping unsupported PRE_GA_WRITE_ROWS_EVENT from: " + context.getLogPosition()));
                break;
            }
            case 21: {
                if (!logger.isWarnEnabled()) break;
                logger.warn((Object)("Skipping unsupported PRE_GA_UPDATE_ROWS_EVENT from: " + context.getLogPosition()));
                break;
            }
            case 22: {
                if (!logger.isWarnEnabled()) break;
                logger.warn((Object)("Skipping unsupported PRE_GA_DELETE_ROWS_EVENT from: " + context.getLogPosition()));
                break;
            }
            case 17: {
                BeginLoadQueryLogEvent event = new BeginLoadQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 18: {
                ExecuteLoadQueryLogEvent event = new ExecuteLoadQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 26: {
                IncidentLogEvent event = new IncidentLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 27: {
                HeartbeatLogEvent event = new HeartbeatLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 28: {
                IgnorableLogEvent event = new IgnorableLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 29: {
                RowsQueryLogEvent event = new RowsQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 39: {
                UpdateRowsLogEvent event = new UpdateRowsLogEvent(header, buffer, descriptionEvent, true);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 33: 
            case 34: {
                GtidLogEvent event = new GtidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                if (gtidSet != null) {
                    gtidSet.update(event.getGtidStr());
                    header.putGtid(gtidSet, event);
                }
                context.setGtidLogEvent(event);
                return event;
            }
            case 35: {
                PreviousGtidsLogEvent event = new PreviousGtidsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 36: {
                TransactionContextLogEvent event = new TransactionContextLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 40: {
                TransactionPayloadLogEvent event = new TransactionPayloadLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 37: {
                ViewChangeEvent event = new ViewChangeEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 38: {
                XaPrepareLogEvent event = new XaPrepareLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 160: {
                AnnotateRowsEvent event = new AnnotateRowsEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                header.putGtid(context.getGtidSet(), gtidLogEvent);
                return event;
            }
            case 161: {
                BinlogCheckPointLogEvent event = new BinlogCheckPointLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 162: {
                MariaGtidLogEvent event = new MariaGtidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                if (gtidSet != null) {
                    gtidSet.update(event.getGtidStr());
                    header.putGtid(gtidSet, event);
                }
                context.setGtidLogEvent(event);
                return event;
            }
            case 163: {
                MariaGtidListLogEvent event = new MariaGtidListLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                if (gtidSet != null) {
                    gtidSet.update(event.getGtidStr());
                    header.putGtid(gtidSet, event);
                }
                context.setGtidLogEvent(event);
                return event;
            }
            case 164: {
                StartEncryptionLogEvent event = new StartEncryptionLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            default: {
                if ((buffer.getUint16(17) & 0x80) > 0) {
                    IgnorableLogEvent event = new IgnorableLogEvent(header, buffer, descriptionEvent);
                    logPosition.position = header.getLogPos();
                    return event;
                }
                if (!logger.isWarnEnabled()) break;
                logger.warn((Object)("Skipping unrecognized binlog event " + LogEvent.getTypeName(header.getType()) + " from: " + context.getLogPosition()));
            }
        }
        logPosition.position = header.getLogPos();
        return new UnknownLogEvent(header);
    }
}

