/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.config.listener.FuzzyWatchEventWatcher;
import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchChangeNotifyRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchSyncRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigFuzzyWatchChangeNotifyResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigFuzzyWatchResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigFuzzyWatchSyncResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.client.config.common.GroupKey;
import com.alibaba.nacos.client.config.impl.ClientWorker;
import com.alibaba.nacos.client.config.impl.ConfigFuzzyWatchContext;
import com.alibaba.nacos.client.config.impl.ConfigFuzzyWatchLoadEvent;
import com.alibaba.nacos.client.config.impl.ConfigFuzzyWatchNotifyEvent;
import com.alibaba.nacos.client.config.impl.ConfigFuzzyWatcherWrapper;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class ConfigFuzzyWatchGroupKeyHolder
extends SmartSubscriber
implements Closeable {
    private static final Logger LOGGER = LogUtils.logger(ClientWorker.class);
    private final ClientWorker.ConfigRpcTransportClient agent;
    private final String clientUuid;
    private final BlockingQueue<Object> fuzzyListenExecuteBell = new ArrayBlockingQueue<Object>(1);
    private final Object bellItem = new Object();
    private final AtomicLong fuzzyListenLastAllSyncTime = new AtomicLong(System.currentTimeMillis());
    private static final long FUZZY_LISTEN_ALL_SYNC_INTERNAL = 180000L;
    private String taskId = "0";
    private final AtomicReference<Map<String, ConfigFuzzyWatchContext>> fuzzyListenContextMap = new AtomicReference(new HashMap());

    public ConfigFuzzyWatchGroupKeyHolder(ClientWorker.ConfigRpcTransportClient agent, String clientUuid) {
        this.clientUuid = clientUuid;
        this.agent = agent;
        NotifyCenter.registerSubscriber(this);
    }

    public void start() {
        ScheduledExecutorService agentExecutor = this.agent.getExecutor();
        agentExecutor.submit(() -> {
            while (!agentExecutor.isShutdown() && !agentExecutor.isTerminated()) {
                try {
                    this.fuzzyListenExecuteBell.poll(5L, TimeUnit.SECONDS);
                    if (agentExecutor.isShutdown() || agentExecutor.isTerminated()) continue;
                    this.executeConfigFuzzyListen();
                }
                catch (Throwable e) {
                    LOGGER.error("[rpc-fuzzy-listen-execute] rpc fuzzy listen exception", e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyFuzzyWatchSync();
                }
            }
        });
    }

    @Override
    public void shutdown() {
        NotifyCenter.deregisterSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFuzzyListenContext(String groupKeyPattern) {
        AtomicReference<Map<String, ConfigFuzzyWatchContext>> atomicReference = this.fuzzyListenContextMap;
        synchronized (atomicReference) {
            HashMap<String, ConfigFuzzyWatchContext> copy = new HashMap<String, ConfigFuzzyWatchContext>(this.fuzzyListenContextMap.get());
            copy.remove(groupKeyPattern);
            this.fuzzyListenContextMap.set(copy);
        }
        LOGGER.info("[{}] [fuzzy-watch-unsubscribe] {}", (Object)this.agent.getName(), (Object)groupKeyPattern);
    }

    public ConfigFuzzyWatchContext registerFuzzyWatcher(String dataIdPattern, String groupPattern, FuzzyWatchEventWatcher fuzzyWatchEventWatcher) {
        ConfigFuzzyWatcherWrapper configFuzzyWatcherWrapper;
        if (!this.agent.isAbilitySupportedByServer(AbilityKey.SERVER_FUZZY_WATCH)) {
            throw new NacosRuntimeException(501, "Request Nacos server version is too low, not support fuzzy watch feature.");
        }
        ConfigFuzzyWatchContext configFuzzyWatchContext = this.initFuzzyWatchContextIfAbsent(dataIdPattern, groupPattern);
        if (configFuzzyWatchContext.addWatcher(configFuzzyWatcherWrapper = new ConfigFuzzyWatcherWrapper(fuzzyWatchEventWatcher)) && configFuzzyWatchContext.getReceivedGroupKeys() != null) {
            for (String groupKey : configFuzzyWatchContext.getReceivedGroupKeys()) {
                ConfigFuzzyWatchNotifyEvent configFuzzyWatchNotifyEvent = ConfigFuzzyWatchNotifyEvent.buildEvent(groupKey, configFuzzyWatchContext.getGroupKeyPattern(), "ADD_CONFIG", "FUZZY_WATCH_INIT_NOTIFY", configFuzzyWatcherWrapper.getUuid());
                NotifyCenter.publishEvent(configFuzzyWatchNotifyEvent);
            }
        }
        return configFuzzyWatchContext;
    }

    public ConfigFuzzyWatchContext getFuzzyListenContext(String dataIdPattern, String groupPattern) {
        return this.fuzzyListenContextMap.get().get(FuzzyGroupKeyPattern.generatePattern(dataIdPattern, groupPattern, this.agent.getTenant()));
    }

    ConfigFuzzyWatchSyncResponse handleFuzzyWatchSyncNotifyRequest(ConfigFuzzyWatchSyncRequest request) {
        String groupKeyPattern = request.getGroupKeyPattern();
        ConfigFuzzyWatchContext context = this.fuzzyListenContextMap.get().get(groupKeyPattern);
        if ("FINISH_FUZZY_WATCH_INIT_NOTIFY".equals(request.getSyncType())) {
            LOGGER.info("[{}] [fuzzy-watch] init-notify-finished, pattern ->{}, match group keys count {}", new Object[]{this.agent.getName(), request.getGroupKeyPattern(), context.getReceivedGroupKeysCount()});
            context.markInitializationComplete();
            return new ConfigFuzzyWatchSyncResponse();
        }
        LOGGER.info("[{}] [fuzzy-watch] sync notify , pattern ->{},syncType={},,syncCount={},totalBatch={},currentBatch={}", new Object[]{this.agent.getName(), request.getGroupKeyPattern(), request.getSyncType(), request.getContexts().size(), request.getTotalBatch(), request.getCurrentBatch()});
        block8: for (ConfigFuzzyWatchSyncRequest.Context requestContext : request.getContexts()) {
            switch (requestContext.getChangedType()) {
                case "ADD_CONFIG": {
                    if (!context.addReceivedGroupKey(requestContext.getGroupKey())) continue block8;
                    LOGGER.info("[{}] [fuzzy-watch-diff-sync-push] local match group key added ,pattern ->{}, group key  ->{},publish fuzzy watch notify event", new Object[]{this.agent.getName(), request.getGroupKeyPattern(), requestContext.getGroupKey()});
                    NotifyCenter.publishEvent(ConfigFuzzyWatchNotifyEvent.buildEvent(requestContext.getGroupKey(), request.getGroupKeyPattern(), requestContext.getChangedType(), request.getSyncType(), this.clientUuid));
                    continue block8;
                }
                case "DELETE_CONFIG": {
                    if (!context.removeReceivedGroupKey(requestContext.getGroupKey())) continue block8;
                    LOGGER.info("[{}] [fuzzy-watch-diff-sync-push] local match group key remove ,pattern ->{}, group key  ->{},publish fuzzy watch notify event", new Object[]{this.agent.getName(), request.getGroupKeyPattern(), requestContext.getGroupKey()});
                    NotifyCenter.publishEvent(ConfigFuzzyWatchNotifyEvent.buildEvent(requestContext.getGroupKey(), request.getGroupKeyPattern(), requestContext.getChangedType(), request.getSyncType(), this.clientUuid));
                    continue block8;
                }
            }
            LOGGER.warn("Invalid config change type: {}", (Object)requestContext.getChangedType());
        }
        return new ConfigFuzzyWatchSyncResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFuzzyWatcher(String dataIdPattern, String groupPattern, FuzzyWatchEventWatcher watcher) {
        ConfigFuzzyWatchContext configFuzzyWatchContext = this.getFuzzyListenContext(dataIdPattern, groupPattern);
        if (configFuzzyWatchContext != null) {
            ConfigFuzzyWatchContext configFuzzyWatchContext2 = configFuzzyWatchContext;
            synchronized (configFuzzyWatchContext2) {
                configFuzzyWatchContext.removeWatcher(watcher);
                if (configFuzzyWatchContext.getConfigFuzzyWatcherWrappers().isEmpty()) {
                    configFuzzyWatchContext.setDiscard(true);
                    configFuzzyWatchContext.setConsistentWithServer(false);
                }
            }
        }
    }

    ConfigFuzzyWatchChangeNotifyResponse handlerFuzzyWatchChangeNotifyRequest(ConfigFuzzyWatchChangeNotifyRequest request) {
        LOGGER.info("[{}] [fuzzy-watch-change-notify-push] changeType={},groupKey={}", new Object[]{this.agent.getName(), request.getChangeType(), request.getGroupKey()});
        Map<String, ConfigFuzzyWatchContext> listenContextMap = this.fuzzyListenContextMap.get();
        String[] groupItems = GroupKey.parseKey(request.getGroupKey());
        Set<String> matchedPatterns = FuzzyGroupKeyPattern.filterMatchedPatterns(listenContextMap.keySet(), groupItems[0], groupItems[1], groupItems[2]);
        for (String matchedPattern : matchedPatterns) {
            ConfigFuzzyWatchContext context = listenContextMap.get(matchedPattern);
            if ("ADD_CONFIG".equals(request.getChangeType()) || "CONFIG_CHANGED".equals(request.getChangeType())) {
                if (!context.addReceivedGroupKey(request.getGroupKey())) continue;
                LOGGER.info("[{}] [fuzzy-watch-change-notify-push] match group key added ,pattern={},groupKey={}", new Object[]{this.agent.getName(), request.getChangeType(), request.getGroupKey()});
                NotifyCenter.publishEvent(ConfigFuzzyWatchNotifyEvent.buildEvent(request.getGroupKey(), matchedPattern, "ADD_CONFIG", "FUZZY_WATCH_RESOURCE_CHANGED", this.clientUuid));
                continue;
            }
            if (!"DELETE_CONFIG".equals(request.getChangeType()) || !context.removeReceivedGroupKey(request.getGroupKey())) continue;
            NotifyCenter.publishEvent(ConfigFuzzyWatchNotifyEvent.buildEvent(request.getGroupKey(), matchedPattern, "DELETE_CONFIG", "FUZZY_WATCH_RESOURCE_CHANGED", this.clientUuid));
        }
        return new ConfigFuzzyWatchChangeNotifyResponse();
    }

    void notifyFuzzyWatchSync() {
        this.fuzzyListenExecuteBell.offer(this.bellItem);
    }

    public void executeConfigFuzzyListen() throws NacosException {
        long now = System.currentTimeMillis();
        boolean needAllSync = now - this.fuzzyListenLastAllSyncTime.get() >= 180000L;
        ArrayList<ConfigFuzzyWatchContext> needSyncContexts = new ArrayList<ConfigFuzzyWatchContext>();
        for (ConfigFuzzyWatchContext context : this.fuzzyListenContextMap.get().values()) {
            if (context.isConsistentWithServer()) {
                context.syncFuzzyWatchers();
                if (!needAllSync) continue;
            }
            needSyncContexts.add(context);
        }
        this.doExecuteConfigFuzzyListen(needSyncContexts);
        if (needAllSync) {
            this.fuzzyListenLastAllSyncTime.set(now);
        }
    }

    void resetConsistenceStatus() {
        Collection<ConfigFuzzyWatchContext> configFuzzyWatchContexts = this.fuzzyListenContextMap.get().values();
        for (ConfigFuzzyWatchContext context : configFuzzyWatchContexts) {
            context.setConsistentWithServer(false);
        }
    }

    private void doExecuteConfigFuzzyListen(List<ConfigFuzzyWatchContext> contextLists) throws NacosException {
        if (CollectionUtils.isEmpty(contextLists)) {
            return;
        }
        ArrayList listenFutures = new ArrayList();
        RpcClient rpcClient = this.agent.ensureRpcClient(this.taskId);
        for (ConfigFuzzyWatchContext configFuzzyWatchContext : contextLists) {
            ScheduledExecutorService executorService = this.agent.getExecutor();
            Future<?> future = executorService.submit(() -> this.executeFuzzyWatchRequest(context, rpcClient));
            listenFutures.add(future);
        }
        for (Future future : listenFutures) {
            try {
                future.get();
            }
            catch (Throwable throwable) {
                LOGGER.error("Async fuzzy listen config change error.", throwable);
            }
        }
    }

    void executeFuzzyWatchRequest(ConfigFuzzyWatchContext context, RpcClient rpcClient) {
        ConfigFuzzyWatchRequest configFuzzyWatchRequest = this.buildFuzzyListenConfigRequest(context);
        try {
            ConfigFuzzyWatchResponse listenResponse = (ConfigFuzzyWatchResponse)this.agent.requestProxy(rpcClient, configFuzzyWatchRequest);
            if (listenResponse != null && listenResponse.isSuccess()) {
                if (context.isDiscard()) {
                    this.removeFuzzyListenContext(context.getGroupKeyPattern());
                } else {
                    context.setConsistentWithServer(true);
                }
                context.clearOverLimitTs();
            } else if (listenResponse != null) {
                if (this.handleOverLoadEvent(context.getGroupKeyPattern(), listenResponse.getErrorCode())) {
                    return;
                }
                LOGGER.error("Execute  fuzzy watch config change error,code={},msg={}", (Object)listenResponse.getErrorCode(), (Object)listenResponse.getMessage());
            }
        }
        catch (NacosException e) {
            if (this.handleOverLoadEvent(context.getGroupKeyPattern(), e.getErrCode())) {
                return;
            }
            LOGGER.error("Execute  fuzzy watch config change error.", (Throwable)e);
            this.notifyFuzzyWatchSync();
        }
    }

    private boolean handleOverLoadEvent(String pattern, int errorCode) {
        if (ErrorCode.FUZZY_WATCH_PATTERN_OVER_LIMIT.getCode() == errorCode || ErrorCode.FUZZY_WATCH_PATTERN_MATCH_COUNT_OVER_LIMIT.getCode() == errorCode) {
            LOGGER.warn(" fuzzy watch pattern over limit,pattern ->{} ,fuzzy watch will be suppressed", (Object)pattern);
            NotifyCenter.publishEvent(ConfigFuzzyWatchLoadEvent.buildEvent(errorCode, pattern, this.clientUuid));
            return true;
        }
        return false;
    }

    private ConfigFuzzyWatchRequest buildFuzzyListenConfigRequest(ConfigFuzzyWatchContext context) {
        ConfigFuzzyWatchRequest request = new ConfigFuzzyWatchRequest();
        request.setGroupKeyPattern(context.getGroupKeyPattern());
        request.setInitializing(context.isInitializing());
        request.setWatchType(context.isDiscard() && CollectionUtils.isEmpty(context.getConfigFuzzyWatcherWrappers()) ? "CANCEL_WATCH" : "WATCH");
        request.setReceivedGroupKeys(context.getReceivedGroupKeys());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigFuzzyWatchContext initFuzzyWatchContextIfAbsent(String dataIdPattern, String groupPattern) {
        ConfigFuzzyWatchContext context = this.getFuzzyListenContext(dataIdPattern, groupPattern);
        if (context != null) {
            return context;
        }
        AtomicReference<Map<String, ConfigFuzzyWatchContext>> atomicReference = this.fuzzyListenContextMap;
        synchronized (atomicReference) {
            ConfigFuzzyWatchContext contextFromMap = this.getFuzzyListenContext(dataIdPattern, groupPattern);
            if (contextFromMap != null) {
                context = contextFromMap;
            } else {
                String groupKeyPattern = FuzzyGroupKeyPattern.generatePattern(dataIdPattern, groupPattern, this.agent.getTenant());
                context = new ConfigFuzzyWatchContext(this.agent.getName(), groupKeyPattern);
                context.setConsistentWithServer(false);
                HashMap<String, ConfigFuzzyWatchContext> copy = new HashMap<String, ConfigFuzzyWatchContext>(this.fuzzyListenContextMap.get());
                copy.put(groupKeyPattern, context);
                LOGGER.info("[{}][fuzzy-watch] init fuzzy watch context , groupKeyPattern={} ,notify fuzzy watch sync ", (Object)this.agent.getName(), (Object)groupKeyPattern);
                this.fuzzyListenContextMap.set(copy);
                this.notifyFuzzyWatchSync();
            }
        }
        return context;
    }

    @Override
    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ConfigFuzzyWatchNotifyEvent.class);
        result.add(ConfigFuzzyWatchLoadEvent.class);
        return result;
    }

    @Override
    public void onEvent(Event event) {
        ConfigFuzzyWatchContext context;
        if (event instanceof ConfigFuzzyWatchNotifyEvent) {
            ConfigFuzzyWatchNotifyEvent configFuzzyWatchNotifyEvent = (ConfigFuzzyWatchNotifyEvent)event;
            if (!configFuzzyWatchNotifyEvent.getClientUuid().equals(this.clientUuid)) {
                return;
            }
            context = this.fuzzyListenContextMap.get().get(configFuzzyWatchNotifyEvent.getGroupKeyPattern());
            if (context == null) {
                return;
            }
            context.notifyWatcher(configFuzzyWatchNotifyEvent.getGroupKey(), configFuzzyWatchNotifyEvent.getChangedType(), configFuzzyWatchNotifyEvent.getSyncType(), configFuzzyWatchNotifyEvent.getWatcherUuid());
        }
        if (event instanceof ConfigFuzzyWatchLoadEvent) {
            ConfigFuzzyWatchLoadEvent loadEvent = (ConfigFuzzyWatchLoadEvent)event;
            if (!loadEvent.getClientUuid().equals(this.clientUuid)) {
                return;
            }
            context = this.fuzzyListenContextMap.get().get(loadEvent.getGroupKeyPattern());
            if (context == null) {
                return;
            }
            context.notifyLoaderWatcher(loadEvent.getCode());
        }
    }
}

