/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.security.spi;

import com.alibaba.csb.sdk.security.DefaultSignServiceImpl;
import com.alibaba.csb.security.spi.SignService;
import com.alibaba.csb.security.spi.VerifySignService;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class SignServiceRuntime {
    public static final String DefaultSignImpl = System.getProperty(SignService.class.getName());
    public static final String DefaultVerifySignImpl = System.getProperty(VerifySignService.class.getName());
    private static ServiceLoader<SignService> serviceLoader = ServiceLoader.load(SignService.class);
    private static final Map<String, SignService> signServiceMap = new HashMap<String, SignService>();
    private static SignService defaultServiceLoadedSignService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignService pickSignService(String signImpl) {
        if (signImpl == null) {
            signImpl = DefaultSignImpl;
        }
        if (signImpl == null) {
            if (defaultServiceLoadedSignService != null) return defaultServiceLoadedSignService;
            Class<SignServiceRuntime> clazz = SignServiceRuntime.class;
            synchronized (SignServiceRuntime.class) {
                Iterator<SignService> it = serviceLoader.iterator();
                defaultServiceLoadedSignService = it.hasNext() ? it.next() : DefaultSignServiceImpl.getInstance();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultServiceLoadedSignService;
            }
        }
        SignService signService = signServiceMap.get(signImpl);
        if (signService != null) return signService;
        Map<String, SignService> map = signServiceMap;
        synchronized (map) {
            signService = SignServiceRuntime.getNewSignService(signImpl);
            signServiceMap.put(signImpl, signService);
            return signService;
        }
    }

    private static SignService getNewSignService(String pickImpl) {
        for (SignService ss : serviceLoader) {
            if (!pickImpl.equals(ss.getClass().getName())) continue;
            return ss;
        }
        AccessControlContext acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
            final Class<?> cc = Class.forName(pickImpl, false, loader);
            if (!SignService.class.isAssignableFrom(cc)) {
                throw new IllegalArgumentException(String.format("The class %s is not implement interface: com.alibaba.csb.security.spi.SignService", pickImpl));
            }
            PrivilegedAction<SignService> action = new PrivilegedAction<SignService>(){

                @Override
                public SignService run() {
                    try {
                        return (SignService)SignService.class.cast(cc.newInstance());
                    }
                    catch (Throwable e) {
                        throw new Error(e);
                    }
                }
            };
            return AccessController.doPrivileged(action, acc);
        }
        catch (ClassNotFoundException x) {
            throw new IllegalArgumentException(String.format("Can not class-found SPI provider for name:%s", pickImpl));
        }
    }

    public static String pickVerifySignImplName(String vefifySignImpl) {
        if (vefifySignImpl == null) {
            vefifySignImpl = DefaultVerifySignImpl;
        }
        return vefifySignImpl;
    }
}

