/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.security;

import com.alibaba.csb.sdk.CsbSDKConstants;
import com.alibaba.csb.sdk.SdkLogger;
import com.alibaba.csb.sdk.security.DefaultSignServiceImpl;
import com.alibaba.csb.sdk.security.ParamNode;
import com.alibaba.csb.sdk.security.SortedParamList;
import com.alibaba.csb.sdk.security.SpasSigner;
import com.alibaba.csb.security.spi.SignService;
import com.alibaba.csb.security.spi.SignServiceRuntime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SignUtil {
    private static final Random random = new Random(System.currentTimeMillis());

    public static Map<String, String> newParamsMap(Map<String, List<String>> paramsMap, String apiName, String version, String accessKey, String securityKey, boolean timestampFlag, boolean nonceFlag, Map<String, String> extSignHeaders, StringBuffer signDiagnosticInfo, String signImpl, String vefifySignImpl) {
        String timestampStr;
        HashMap<String, List<String>> newParamsMap = new HashMap<String, List<String>>();
        HashMap<String, String> headerParamsMap = new HashMap<String, String>();
        if (paramsMap != null) {
            newParamsMap.putAll(paramsMap);
        }
        if (apiName != null) {
            newParamsMap.put("_api_name", Arrays.asList(apiName));
            headerParamsMap.put("_api_name", apiName);
        }
        if (version != null) {
            newParamsMap.put("_api_version", Arrays.asList(version));
            headerParamsMap.put("_api_version", version);
        }
        if ((timestampStr = System.getProperty("timestamp")) == null) {
            Long ts = System.currentTimeMillis();
            timestampStr = ts.toString();
        }
        if (nonceFlag && CsbSDKConstants.isNonceEnabled) {
            Object nonceStr = System.getProperty("nonce");
            if (nonceStr == null) {
                Long l = random.nextLong();
                nonceStr = l.toString();
            }
            newParamsMap.put("_api_nonce", Arrays.asList(nonceStr));
            headerParamsMap.put("_api_nonce", (String)nonceStr);
        }
        if (timestampFlag) {
            newParamsMap.put("_api_timestamp", Arrays.asList(timestampStr));
            headerParamsMap.put("_api_timestamp", timestampStr);
        }
        if (extSignHeaders != null) {
            for (Map.Entry entry : extSignHeaders.entrySet()) {
                newParamsMap.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                headerParamsMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ((vefifySignImpl = SignServiceRuntime.pickVerifySignImplName(vefifySignImpl)) != null) {
            newParamsMap.put("_api_verify_sign_impl", Arrays.asList(vefifySignImpl));
            headerParamsMap.put("_api_verify_sign_impl", vefifySignImpl);
        }
        if (accessKey != null) {
            headerParamsMap.put("_api_access_key", accessKey);
            newParamsMap.put("_api_access_key", Arrays.asList(accessKey));
            newParamsMap.remove("_api_signature");
            newParamsMap.remove("_api_secret_key");
            long currT = System.currentTimeMillis();
            SignService signService = SignServiceRuntime.pickSignService(signImpl);
            signImpl = signService.getClass().getCanonicalName();
            if (!signImpl.equals(DefaultSignServiceImpl.class.getCanonicalName())) {
                newParamsMap.put("_api_sign_impl", Arrays.asList(signImpl));
                headerParamsMap.put("_api_sign_impl", signImpl);
            }
            SortedParamList paramNodeList = SignUtil.convertMultiValueParams(newParamsMap);
            String signKey = signService.generateSignature(paramNodeList, accessKey, securityKey);
            if (SdkLogger.isLoggable() || signDiagnosticInfo != null) {
                StringBuffer msg = new StringBuffer();
                msg.append("sign parameters:\n");
                boolean first = true;
                for (String key : newParamsMap.keySet()) {
                    if (!first) {
                        msg.append(", ");
                    }
                    msg.append(String.format("%s=%s", key, newParamsMap.get(key)));
                    first = false;
                }
                msg.append("===signature:" + signKey).append(", ").append("===costs time:" + (System.currentTimeMillis() - currT) + "ms");
                if (signDiagnosticInfo != null) {
                    signDiagnosticInfo.setLength(0);
                    signDiagnosticInfo.append(msg.toString());
                }
                if (SdkLogger.isLoggable()) {
                    SdkLogger.print(msg.toString());
                }
            }
            headerParamsMap.put("_api_signature", signKey);
        }
        return headerParamsMap;
    }

    public static SortedParamList convertMultiValueParams(Map<String, List<String>> map) {
        SortedParamList pnList = new SortedParamList();
        if (map == null) {
            return pnList;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> vlist = entry.getValue();
            if (vlist == null) {
                ParamNode node = new ParamNode(key, null);
                pnList.add(node);
                continue;
            }
            for (String v : vlist) {
                ParamNode node = new ParamNode(key, v);
                pnList.add(node);
            }
        }
        return pnList;
    }

    private static SortedParamList convertSingleValueParms(Map<String, String> map) {
        SortedParamList sortedParamList = new SortedParamList();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                ParamNode node = new ParamNode(key, entry.getValue());
                sortedParamList.add(node);
            }
        }
        return sortedParamList;
    }

    public static String sign(Map<String, String> paramsMap, String secretKey) {
        return SignUtil.sign(SignUtil.convertSingleValueParms(paramsMap), secretKey);
    }

    private static String sign(SortedParamList sortedParamList, String secretKey) {
        return SpasSigner.sign(sortedParamList, secretKey);
    }

    public static void warmup() {
        SignServiceRuntime.pickSignService(null).generateSignature(new SortedParamList(), "ak", "sk");
    }
}

