/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.internel;

import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.ContentEncoding;
import com.alibaba.csb.sdk.GZipUtils;
import com.alibaba.csb.sdk.HttpCallerException;
import com.alibaba.csb.sdk.HttpParameters;
import com.alibaba.csb.sdk.SdkLogger;
import com.alibaba.csb.sdk.security.SignUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

public class HttpClientHelper {
    public static void printDebugInfo(String msg) {
        if (SdkLogger.isLoggable()) {
            SdkLogger.print(msg);
        }
    }

    public static Map<String, List<String>> convertStrMap2ListStrMap(Map<String, String> paramsMap) {
        if (paramsMap == null) {
            return null;
        }
        HashMap<String, List<String>> stringListMap = new HashMap<String, List<String>>((int)((double)paramsMap.size() * 1.5));
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            stringListMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return stringListMap;
    }

    public static void mergeParams(Map<String, List<String>> urlParamsMap, Map<String, String> paramsMap) throws HttpCallerException {
        HttpClientHelper.mergeParamsList(urlParamsMap, HttpClientHelper.convertStrMap2ListStrMap(paramsMap));
    }

    public static void mergeParamsList(Map<String, List<String>> urlParamsMap, Map<String, List<String>> paramsMap) throws HttpCallerException {
        if (paramsMap != null) {
            for (Map.Entry<String, List<String>> kv : paramsMap.entrySet()) {
                urlParamsMap.put(kv.getKey(), kv.getValue());
            }
        }
    }

    public static Map<String, String> newParamsMap(Map<String, List<String>> paramsMap, String apiName, String version, String accessKey, String securityKey, boolean timestampFlag, boolean nonceFlag, Map<String, String> extSignHeaders, StringBuffer signDiagnosticInfo, String signImpl, String verifySignImpl) {
        return SignUtil.newParamsMap(paramsMap, apiName, version, accessKey, securityKey, timestampFlag, nonceFlag, extSignHeaders, signDiagnosticInfo, signImpl, verifySignImpl);
    }

    public static String trimWhiteSpaces(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    public static String trimUrl(String requestURL) {
        int pos = requestURL.indexOf("?");
        String ret = requestURL;
        if (pos >= 0) {
            ret = requestURL.substring(0, pos);
        }
        return ret;
    }

    public static void validateParams(String apiName, String accessKey, String securityKey, Map<String, List<String>> paramsMap) throws HttpCallerException {
        if (apiName == null) {
            throw new HttpCallerException(new InvalidParameterException("param apiName can not be null!"));
        }
        if (accessKey != null && securityKey == null) {
            throw new HttpCallerException(new InvalidParameterException("param securityKey can not be null for a given accessKey!"));
        }
        if (paramsMap != null) {
            for (Map.Entry<String, List<String>> kv : paramsMap.entrySet()) {
                if (kv.getValue() != null) continue;
                throw new HttpCallerException(new InvalidParameterException(String.format("bad parasMap, the value for key [ %s ] is null, please remove the key or set its value, e.g. \"\"!", kv.getKey())));
            }
        }
    }

    private static String decodeValue(String key, String value, boolean decodeFlag) throws HttpCallerException {
        if (decodeFlag) {
            if (value == null) {
                throw new HttpCallerException("bad params, the value for key {" + key + "} is null!");
            }
            return HttpClientHelper.urlDecoding(value, "UTF-8");
        }
        return value;
    }

    public static Map<String, List<String>> parseUrlParamsMap(String requestURL, boolean decodeFlag) throws HttpCallerException {
        boolean questionMarkFlag = requestURL.contains("?");
        HashMap<String, List<String>> urlParamsMap = new HashMap<String, List<String>>();
        if (questionMarkFlag) {
            String[] params;
            int pos = requestURL.indexOf("?");
            String paramStr = requestURL.substring(pos + 1);
            for (String param : params = paramStr.split("&")) {
                pos = param.indexOf("=");
                if (pos <= 0) {
                    throw new HttpCallerException("bad request URL, url params error:" + requestURL);
                }
                String key = HttpClientHelper.decodeValue("", param.substring(0, pos), decodeFlag);
                String value = param.substring(pos + 1);
                ArrayList<String> values = (ArrayList<String>)urlParamsMap.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(HttpClientHelper.decodeValue(key, value, decodeFlag));
                urlParamsMap.put(key, values);
            }
        }
        return urlParamsMap;
    }

    private static void setHeaders(HttpPost httpPost, Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                httpPost.addHeader(kv.getKey(), kv.getValue());
            }
        }
    }

    public static void setHeaders(HttpGet httpGet, Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                httpGet.addHeader(kv.getKey(), kv.getValue());
            }
        }
    }

    public static String genCurlHeaders(Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                sb.append("-H \"").append(kv.getKey()).append(":").append(kv.getValue()).append("\"  ");
            }
            return sb.toString();
        }
        return "";
    }

    public static String createPostCurlString(String url, Map<String, List<String>> params, Map<String, String> headerParams, ContentBody cb, Map<String, String> directHheaderParamsMap) {
        StringBuffer sb = new StringBuffer("curl ");
        sb.append(HttpClientHelper.genCurlHeaders(directHheaderParamsMap));
        sb.append(HttpClientHelper.genCurlHeaders(headerParams));
        if (params != null) {
            StringBuffer postSB = new StringBuffer();
            for (Map.Entry<String, List<String>> e : params.entrySet()) {
                if (postSB.length() > 0) {
                    postSB.append("&");
                }
                for (String value : e.getValue()) {
                    postSB.append(e.getKey()).append("=").append(HttpClientHelper.urlEncoding(value, "UTF-8"));
                }
            }
            if (postSB.length() > 0) {
                sb.append(" -d \"");
                postSB.append("\"");
                sb.append(postSB.toString());
            } else {
                sb.append("--data ''");
            }
        } else {
            sb.append("--data '");
            sb.append(HttpClientHelper.urlEncodedString(HttpClientHelper.toNVP(params), "UTF-8"));
            sb.append("'");
        }
        sb.append(" --insecure ");
        sb.append("\"");
        sb.append(url);
        sb.append("\"");
        return sb.toString();
    }

    public static String urlEncoding(String str, String encoding) {
        try {
            return URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String urlDecoding(String str, String encoding) {
        try {
            return URLDecoder.decode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static String urlEncodedString(List<NameValuePair> parameters, String charset) {
        return URLEncodedUtils.format(parameters, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET.name());
    }

    public static HttpPost createPost(String url, Map<String, List<String>> urlParams, Map<String, String> headerParams, ContentBody cb, Map<String, HttpParameters.AttachFile> fileMap, ContentEncoding contentEncoding, ContentType contentType) {
        String newParamStr;
        String newUrl = url;
        List<NameValuePair> nvps = HttpClientHelper.toNVP(urlParams);
        if (cb != null && urlParams != null && !"".equals(newParamStr = HttpClientHelper.urlEncodedString(nvps, "UTF-8"))) {
            newUrl = !url.contains("?") ? String.format("%s?%s", url, newParamStr) : String.format("%s&%s", url, newParamStr);
        }
        if (contentType == null) {
            contentType = cb != null ? (cb.getStrContentBody() != null ? ContentType.APPLICATION_JSON.withCharset("UTF-8") : ContentType.APPLICATION_OCTET_STREAM) : ContentType.APPLICATION_FORM_URLENCODED.withCharset("UTF-8");
        }
        HttpPost httpost = new HttpPost(newUrl);
        HttpClientHelper.setHeaders(httpost, headerParams);
        if (fileMap == null || fileMap.isEmpty()) {
            httpost.addHeader("Content-Type", contentType.toString());
        }
        try {
            HttpEntity entity;
            if (fileMap != null && !fileMap.isEmpty()) {
                MultipartEntityBuilder multiBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
                for (NameValuePair nameValuePair : nvps) {
                    String name = nameValuePair.getName();
                    String value = nameValuePair.getValue();
                    if (contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                        name = HttpClientHelper.urlEncoding(nameValuePair.getName(), contentType.getCharset().name());
                        value = HttpClientHelper.urlEncoding(nameValuePair.getValue(), contentType.getCharset().name());
                    }
                    if (ContentEncoding.gzip.equals((Object)contentEncoding)) {
                        byte[] bytes = GZipUtils.gzipBytes(value.getBytes("UTF-8"));
                        ByteArrayBody body = new ByteArrayBody(bytes, contentType, null);
                        FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create(name, body);
                        partBuilder.setField("Content-Encoding", "gzip");
                        multiBuilder.addPart(partBuilder.build());
                        continue;
                    }
                    multiBuilder.addTextBody(name, value, contentType);
                }
                for (Map.Entry entry : fileMap.entrySet()) {
                    HttpParameters.AttachFile file = (HttpParameters.AttachFile)entry.getValue();
                    if (ContentEncoding.gzip.equals((Object)file.getContentEncoding())) {
                        FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create((String)entry.getKey(), new ByteArrayBody(GZipUtils.gzipBytes(file.getFileBytes()), file.getFileName()));
                        partBuilder.setField("Content-Encoding", "gzip");
                        multiBuilder.addPart(partBuilder.build());
                        continue;
                    }
                    multiBuilder.addBinaryBody((String)entry.getKey(), file.getFileBytes(), ContentType.DEFAULT_BINARY, file.getFileName());
                }
                entity = multiBuilder.build();
            } else if (cb == null) {
                entity = new UrlEncodedFormEntity(nvps, "UTF-8");
                if (ContentEncoding.gzip.equals((Object)contentEncoding)) {
                    entity = new GzipCompressingEntity(entity);
                    httpost.setHeader("Content-Encoding", "gzip");
                }
            } else {
                if (ContentEncoding.gzip.equals((Object)contentEncoding)) {
                    httpost.setHeader("Content-Encoding", "gzip");
                }
                if (cb.getStrContentBody() != null) {
                    entity = new StringEntity(cb.getStrContentBody(), contentType);
                    if (ContentEncoding.gzip.equals((Object)contentEncoding)) {
                        entity = new GzipCompressingEntity(entity);
                    }
                } else {
                    entity = new ByteArrayEntity(cb.getBytesContentBody(), contentType);
                    if (ContentEncoding.gzip.equals((Object)contentEncoding)) {
                        entity = new GzipCompressingEntity(entity);
                    }
                }
            }
            httpost.setEntity(entity);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return httpost;
    }

    private static List<NameValuePair> toNVP(Map<String, List<String>> urlParams) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        if (urlParams != null) {
            Set<String> keySet = urlParams.keySet();
            for (String key : keySet) {
                for (String value : urlParams.get(key)) {
                    nvps.add(new BasicNameValuePair(key, value));
                }
            }
        }
        return nvps;
    }

    public static void setDirectHeaders(HttpPost httpPost, Map<String, String> directHheaderParamsMap) {
        if (directHheaderParamsMap == null) {
            return;
        }
        for (Map.Entry<String, String> kv : directHheaderParamsMap.entrySet()) {
            if (kv.getKey() == null || !"Content-Type".equals(kv.getKey()) && httpPost.containsHeader(kv.getKey())) continue;
            httpPost.addHeader(kv.getKey(), kv.getValue());
        }
    }

    public static String getUrlPathInfo(String url) throws HttpCallerException {
        URL urlStr = null;
        try {
            urlStr = new URL(url);
        }
        catch (Exception e) {
            throw new HttpCallerException("url is unformat, url is " + url);
        }
        String path = urlStr.getPath();
        return path;
    }

    public static Map<String, String> fetchResHeaderMap(HttpResponse response) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (response != null) {
            headerMap.put("HTTP-STATUS", String.valueOf(response.getStatusLine().getStatusCode()));
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
        }
        return headerMap;
    }

    public static String fetchResHeaders(HttpResponse response) {
        if (response != null) {
            StringBuffer body = new StringBuffer();
            body.append(String.format("\"%s\":\"%s\"", "HTTP-STATUS", response.getStatusLine()));
            for (Header header : response.getAllHeaders()) {
                if (body.length() > 0) {
                    body.append(",");
                }
                body.append(String.format("\"%s\":\"%s\"", header.getName(), header.getValue()));
            }
            return String.format("{%s}", body.toString());
        }
        return null;
    }

    public static String generateAsEncodeRequestUrl(String requestURL, Map<String, List<String>> urlParamsMap) {
        requestURL = HttpClientHelper.trimUrl(requestURL);
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, List<String>> kv : urlParamsMap.entrySet()) {
            if (params.length() > 0) {
                params.append("&");
            }
            if (kv.getValue() == null) continue;
            List<String> vlist = kv.getValue();
            for (String v : vlist) {
                params.append(HttpClientHelper.urlEncoding(kv.getKey(), "UTF-8")).append("=").append(HttpClientHelper.urlEncoding(v, "UTF-8"));
            }
        }
        String newRequestURL = requestURL;
        if (params.length() > 0) {
            newRequestURL = newRequestURL + "?" + params.toString();
        }
        HttpClientHelper.printDebugInfo("-- requestURL=" + newRequestURL);
        return newRequestURL;
    }

    public static String getParamsUrlEncodingStr(Map<String, List<String>> params) {
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, List<String>> e : params.entrySet()) {
                for (String value : e.getValue()) {
                    sb.append("&").append(HttpClientHelper.urlEncoding(e.getKey(), "UTF-8")).append("=").append(HttpClientHelper.urlEncoding(value, "UTF-8"));
                }
            }
        }
        if (sb.length() > 0) {
            return sb.toString().substring(1);
        }
        return "";
    }
}

