/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.HttpCallerException;
import com.alibaba.csb.sdk.HttpParameters;
import com.alibaba.csb.sdk.HttpReturn;
import com.alibaba.csb.sdk.SdkLogger;
import com.alibaba.csb.sdk.internel.DiagnosticHelper;
import com.alibaba.csb.sdk.internel.HttpClientConnManager;
import com.alibaba.csb.sdk.internel.HttpClientHelper;
import com.alibaba.csb.sdk.security.SignUtil;
import com.alibaba.csb.utils.IPUtils;
import com.alibaba.csb.utils.LogUtils;
import com.alibaba.csb.utils.TraceIdUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpCaller {
    protected static boolean warmupFlag = false;
    protected static final String RESTFUL_PATH_SIGNATURE_KEY = "csb_restful_path_signature_key";
    protected static final String DEFAULT_RESTFUL_PROTOCOL_VERSION = "1.0";
    protected static final String RESTFUL_PROTOCOL_VERION_KEY = "restful_protocol_version";
    public static final String trustCA = System.getProperty("http.caller.ssl.trustca");
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String GZIP = "gzip";
    protected static String defaultAK = null;
    protected static String defaultSK = null;
    protected static ThreadLocal<Boolean> toCurlCmd = new ThreadLocal();
    protected static ThreadLocal<Boolean> toHttpRequest = new ThreadLocal();
    protected static ThreadLocal<HttpHost> proxyConfigThreadLocal = new ThreadLocal();
    protected static final RequestConfig.Builder requestConfigBuilder = HttpClientConnManager.createConnBuilder();
    protected static final ThreadLocal<RequestConfig.Builder> requestConfigBuilderLocal = new ThreadLocal();
    protected static AtomicReference<String> BIZ_ID_KEY = new AtomicReference();
    public static final long TOTAL_FILE_SIZE = Integer.getInteger("csb_httpAttachmentTotalMBSize", 15) * 1024 * 1024;

    protected HttpCaller() {
    }

    public static void bizIdKey(String bizIdKey) {
        BIZ_ID_KEY.compareAndSet(null, bizIdKey);
    }

    public static String bizIdKey() {
        String bizIdKey = BIZ_ID_KEY.get();
        return bizIdKey == null ? "_biz_id" : bizIdKey;
    }

    public static synchronized void warmup() {
        if (warmupFlag) {
            return;
        }
        SignUtil.warmup();
        warmupFlag = true;
    }

    public static void setProxyHost(String hostname, int port, String scheme) {
        proxyConfigThreadLocal.set(new HttpHost(hostname, port, scheme));
    }

    public static void setConnectionParams(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            requestConfigBuilderLocal.set(requestConfigBuilder);
        } else {
            requestConfigBuilderLocal.set(HttpClientConnManager.createConnBuilder(params));
        }
    }

    private static RequestConfig getRequestConfig() {
        RequestConfig.Builder rcBuilder = null;
        rcBuilder = requestConfigBuilderLocal.get() == null ? requestConfigBuilder : requestConfigBuilderLocal.get();
        rcBuilder.setProxy(proxyConfigThreadLocal.get());
        return rcBuilder.build();
    }

    public static void setCurlResponse(boolean flag) {
        toCurlCmd.set(true);
    }

    private static boolean isCurlResponse() {
        return toCurlCmd.get() != null && toCurlCmd.get() == true;
    }

    public static void setToHttpRequest(boolean flag) {
        toHttpRequest.set(true);
    }

    private static boolean isToHttpRequest() {
        try {
            boolean bl = toHttpRequest.get() != null && toHttpRequest.get() == true;
            return bl;
        }
        finally {
            toHttpRequest.remove();
        }
    }

    public static void setCredential(String accessKey, String secretKey) {
        defaultAK = accessKey;
        defaultSK = secretKey;
    }

    public static String changeCharset(String result, String OldcharsetName, String charsetName) throws HttpCallerException {
        if (result == null) {
            return result;
        }
        try {
            return new String(result.getBytes(OldcharsetName), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpCallerException(e);
        }
    }

    public static String changeCharset(String result) throws HttpCallerException {
        return HttpCaller.changeCharset(result, "ISO-8859-1", DEFAULT_CHARSET);
    }

    public static String doGet(String requestURL, String apiName, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doGet(requestURL, apiName, paramsMap, defaultAK, defaultSK);
    }

    public static String doGet(String requestURL, String apiName, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doGet(requestURL, apiName, null, paramsMap, accessKey, secretKey);
    }

    public static String doGet(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doGet(requestURL, apiName, version, paramsMap, accessKey, secretKey, null, null);
    }

    public static String doGet(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey, String signImpl, String verifySignImpl) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).putParamsMapAll(paramsMap).accessKey(accessKey).secretKey(secretKey).signImpl(signImpl).verifySignImpl(verifySignImpl).build();
        return HttpCaller.doGet(hp, null).getResponseStr();
    }

    public static Map<String, String> getCsbHeaders(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.getCsbHeaders(requestURL, apiName, version, paramsMap, accessKey, secretKey, null, null);
    }

    public static Map<String, String> getCsbHeaders(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey, String signImpl, String verifySignImpl) throws HttpCallerException {
        Map<String, List<String>> urlParamsMap = HttpClientHelper.parseUrlParamsMap(requestURL, true);
        HttpClientHelper.mergeParams(urlParamsMap, paramsMap);
        return HttpClientHelper.newParamsMap(urlParamsMap, apiName, version, accessKey, secretKey, true, false, null, null, signImpl, verifySignImpl);
    }

    private static HttpReturn doGet(HttpParameters hp, Map<String, String> extSignHeadersMap) throws HttpCallerException {
        long startT;
        if (!hp.getHeaderParamsMap().containsKey("_inner_ecsb_trace_id")) {
            hp.getHeaderParamsMap().put("_inner_ecsb_trace_id", TraceIdUtils.generate());
            hp.getHeaderParamsMap().put("_inner_ecsb_rpc_id", "0");
        }
        String requestURL = hp.getRequestUrl();
        String apiName = hp.getApi();
        String version = hp.getVersion();
        Map<String, List<String>> paramsMap = hp.getParamsMap();
        String accessKey = hp.getAccessKey();
        String secretKey = hp.getSecretkey();
        Map<String, String> directParamsMap = hp.getHeaderParamsMap();
        String restfulProtocolVersion = hp.getRestfulProtocolVersion();
        HttpReturn ret = new HttpReturn();
        ret.diagnosticFlag = hp.isDiagnostic();
        long initT = startT = System.currentTimeMillis();
        DiagnosticHelper.setStartTime(ret, initT);
        HttpClientHelper.validateParams(apiName, accessKey, secretKey, paramsMap);
        Map<String, List<String>> urlParamsMap = HttpClientHelper.parseUrlParamsMap(requestURL, true);
        HttpClientHelper.mergeParamsList(urlParamsMap, paramsMap);
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("--+++ prepare params costs = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        HttpCaller.startProcessRestful(requestURL, restfulProtocolVersion, urlParamsMap);
        StringBuffer signDiagnosticInfo = DiagnosticHelper.getSignDiagnosticInfo(ret);
        Map<String, String> headerParamsMap = HttpClientHelper.newParamsMap(urlParamsMap, apiName, version, accessKey, secretKey, hp.isTimestamp(), hp.isNonce(), extSignHeadersMap, signDiagnosticInfo, hp.getSignImpl(), hp.getVerifySignImpl());
        DiagnosticHelper.setSignDiagnosticInfo(ret, signDiagnosticInfo);
        HttpCaller.endProcessRestful(restfulProtocolVersion, urlParamsMap, headerParamsMap);
        String newRequestURL = HttpClientHelper.generateAsEncodeRequestUrl(requestURL, urlParamsMap);
        if (HttpCaller.isCurlResponse()) {
            StringBuffer curl = new StringBuffer("curl ");
            curl.append(HttpClientHelper.genCurlHeaders(directParamsMap));
            curl.append(HttpClientHelper.genCurlHeaders(headerParamsMap));
            curl.append(" -k ");
            curl.append("\"").append(newRequestURL).append("\"");
            ret.response = curl.toString();
            return ret;
        }
        if (HttpCaller.isToHttpRequest()) {
            return new HttpReturn(newRequestURL, directParamsMap, headerParamsMap);
        }
        DiagnosticHelper.calcRequestSize(ret, newRequestURL, null, null);
        HttpGet httpGet = new HttpGet(newRequestURL);
        httpGet.setConfig(HttpCaller.getRequestConfig());
        if (directParamsMap != null) {
            HttpClientHelper.setHeaders(httpGet, directParamsMap);
        }
        HttpClientHelper.setHeaders(httpGet, headerParamsMap);
        DiagnosticHelper.setRequestHeaders(ret, httpGet.getAllHeaders());
        String msg = null;
        try {
            ret = HttpCaller.doHttpReq(requestURL, httpGet, ret);
            DiagnosticHelper.setEndTime(ret, System.currentTimeMillis());
            DiagnosticHelper.setInvokeTime(ret, System.currentTimeMillis() - initT);
            HttpReturn httpReturn = ret;
            return httpReturn;
        }
        catch (HttpCallerException e) {
            msg = e.getMessage();
            throw e;
        }
        finally {
            HttpCaller.log(hp, startT, requestURL, ret, msg);
            if (SdkLogger.isLoggable()) {
                SdkLogger.print("-- total = " + (System.currentTimeMillis() - initT) + " ms ");
            }
        }
    }

    private static void endProcessRestful(String restfulProtocolVersion, Map<String, List<String>> urlParamsMap, Map<String, String> headerParamsMap) {
        if (DEFAULT_RESTFUL_PROTOCOL_VERSION.equals(restfulProtocolVersion)) {
            urlParamsMap.remove(RESTFUL_PATH_SIGNATURE_KEY);
            headerParamsMap.put(RESTFUL_PROTOCOL_VERION_KEY, DEFAULT_RESTFUL_PROTOCOL_VERSION);
        }
    }

    private static void startProcessRestful(String requestURL, String restfulProtocolVersion, Map<String, List<String>> urlParamsMap) throws HttpCallerException {
        if (DEFAULT_RESTFUL_PROTOCOL_VERSION.equals(restfulProtocolVersion)) {
            String path = HttpClientHelper.getUrlPathInfo(requestURL);
            if (path == null) {
                throw new HttpCallerException("this request is restful but the request path is\u3000null !");
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(path);
            urlParamsMap.put(RESTFUL_PATH_SIGNATURE_KEY, values);
        }
    }

    private static boolean isSSLProtocol(String requestUrl) {
        if (requestUrl == null) {
            return false;
        }
        return requestUrl.trim().toLowerCase().startsWith("https://");
    }

    private static CloseableHttpClient createSyncHttpClient(String requestURL) throws HttpCallerException {
        CloseableHttpClient httpClient = null;
        if (HttpCaller.isSSLProtocol(requestURL)) {
            try {
                httpClient = HttpClients.custom().setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build()).setSSLHostnameVerifier(new NoopHostnameVerifier()).build();
            }
            catch (KeyManagementException e) {
                throw new HttpCallerException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HttpCallerException(e);
            }
            catch (KeyStoreException e) {
                throw new HttpCallerException(e);
            }
        } else {
            httpClient = HttpClients.createDefault();
        }
        return httpClient;
    }

    private static CloseableHttpAsyncClient createAsyncHttpClient(String requestURL) throws HttpCallerException {
        CloseableHttpAsyncClient httpClient = null;
        if (HttpCaller.isSSLProtocol(requestURL)) {
            try {
                httpClient = HttpAsyncClients.custom().setSSLHostnameVerifier(new NoopHostnameVerifier()).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                }).build()).build();
            }
            catch (KeyManagementException e) {
                throw new HttpCallerException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HttpCallerException(e);
            }
            catch (KeyStoreException e) {
                throw new HttpCallerException(e);
            }
        } else {
            httpClient = HttpAsyncClients.createDefault();
        }
        httpClient.start();
        return httpClient;
    }

    public static String doGet(String requestURL) throws HttpCallerException {
        HttpGet httpGet = new HttpGet(requestURL);
        httpGet.setConfig(HttpCaller.getRequestConfig());
        HttpClientHelper.printDebugInfo("requestURL=" + requestURL);
        return HttpCaller.doHttpReq(requestURL, httpGet, null).getResponseStr();
    }

    public static String doPost(String requestURL, String apiName, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, null, paramsMap);
    }

    public static String doPost(String requestURL, String apiName, String version, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, version, paramsMap, defaultAK, defaultSK);
    }

    public static String doPost(String requestURL, String apiName, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, paramsMap, accessKey, secretKey, null, null);
    }

    public static String doPost(String requestURL, String apiName, Map<String, String> paramsMap, String accessKey, String secretKey, String signImpl, String verifySignImpl) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, null, paramsMap, accessKey, secretKey, signImpl, verifySignImpl);
    }

    public static String doPost(String requestURL, String apiName, String version, ContentBody cb, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, version, cb, accessKey, secretKey, null, null);
    }

    public static String doPost(String requestURL, String apiName, String version, ContentBody cb, String accessKey, String secretKey, String signImpl, String verifySignImpl) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).contentBody(cb).accessKey(accessKey).secretKey(secretKey).signImpl(signImpl).verifySignImpl(verifySignImpl).build();
        return HttpCaller.doPost(hp, null).getResponseStr();
    }

    private static HttpReturn doPost(HttpParameters hp, Map<String, String> extSignHeadersMap) throws HttpCallerException {
        if (!hp.getHeaderParamsMap().containsKey("_inner_ecsb_trace_id")) {
            hp.getHeaderParamsMap().put("_inner_ecsb_trace_id", TraceIdUtils.generate());
            hp.getHeaderParamsMap().put("_inner_ecsb_rpc_id", "0");
        }
        String requestURL = hp.getRequestUrl();
        String apiName = hp.getApi();
        String version = hp.getVersion();
        Map<String, List<String>> paramsMap = hp.getParamsMap();
        ContentBody cb = hp.getContentBody();
        String accessKey = hp.getAccessKey();
        String secretKey = hp.getSecretkey();
        Map<String, String> directHheaderParamsMap = hp.getHeaderParamsMap();
        String restfulProtocolVersion = hp.getRestfulProtocolVersion();
        boolean nonceFlag = hp.isNonce();
        HttpReturn ret = new HttpReturn();
        ret.diagnosticFlag = hp.isDiagnostic();
        long startT = System.currentTimeMillis();
        DiagnosticHelper.setStartTime(ret, startT);
        HttpClientHelper.validateParams(apiName, accessKey, secretKey, paramsMap);
        Map<String, List<String>> urlParamsMap = HttpClientHelper.parseUrlParamsMap(requestURL, true);
        String newRequestURL = HttpClientHelper.generateAsEncodeRequestUrl(requestURL, urlParamsMap);
        HttpClientHelper.mergeParamsList(urlParamsMap, paramsMap);
        HttpCaller.startProcessRestful(newRequestURL, restfulProtocolVersion, urlParamsMap);
        if (cb == null || hp.isSignContentBody()) {
            // empty if block
        }
        StringBuffer signDiagnosticInfo = DiagnosticHelper.getSignDiagnosticInfo(ret);
        Map<String, String> headerParamsMap = HttpClientHelper.newParamsMap(urlParamsMap, apiName, version, accessKey, secretKey, true, nonceFlag, extSignHeadersMap, signDiagnosticInfo, hp.getSignImpl(), hp.getVerifySignImpl());
        DiagnosticHelper.setSignDiagnosticInfo(ret, signDiagnosticInfo);
        HttpCaller.endProcessRestful(restfulProtocolVersion, urlParamsMap, headerParamsMap);
        if (HttpCaller.isCurlResponse()) {
            return new HttpReturn(HttpClientHelper.createPostCurlString(newRequestURL, paramsMap, headerParamsMap, cb, directHheaderParamsMap));
        }
        if (HttpCaller.isToHttpRequest()) {
            String body = cb == null || cb.getStrContentBody() == null ? HttpClientHelper.getParamsUrlEncodingStr(paramsMap) : cb.getStrContentBody();
            return new HttpReturn(newRequestURL, directHheaderParamsMap, headerParamsMap, body);
        }
        DiagnosticHelper.calcRequestSize(ret, newRequestURL, paramsMap, cb);
        HttpPost httpPost = HttpClientHelper.createPost(newRequestURL, paramsMap, headerParamsMap, cb, hp.getAttachFileMap(), hp.getContentEncoding(), hp.getContentType());
        DiagnosticHelper.setRequestHeaders(ret, httpPost.getAllHeaders());
        HttpClientHelper.setDirectHeaders(httpPost, directHheaderParamsMap);
        httpPost.setConfig(HttpCaller.getRequestConfig());
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("-- prepare time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        String msg = null;
        try {
            ret = HttpCaller.doHttpReq(newRequestURL, httpPost, ret);
            DiagnosticHelper.setEndTime(ret, System.currentTimeMillis());
            DiagnosticHelper.setInvokeTime(ret, System.currentTimeMillis() - startT);
            HttpReturn httpReturn = ret;
            return httpReturn;
        }
        catch (HttpCallerException e) {
            msg = e.getMessage();
            throw e;
        }
        finally {
            HttpCaller.log(hp, startT, requestURL, ret, msg);
            if (SdkLogger.isLoggable()) {
                SdkLogger.print("-- total = " + (System.currentTimeMillis() - startT) + " ms ");
            }
        }
    }

    private static HttpReturn doHttpReq(String requestURL, HttpRequestBase httpRequestBase, HttpReturn ret) throws HttpCallerException {
        boolean async = HttpCaller.isAsync();
        if (async) {
            return HttpCaller.doAsyncHttpReq(requestURL, httpRequestBase, ret);
        }
        return HttpCaller.doSyncHttpReq(requestURL, httpRequestBase, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpReturn doSyncHttpReq(String requestURL, HttpRequestBase httpRequestBase, HttpReturn ret) throws HttpCallerException {
        HttpReturn httpReturn;
        CloseableHttpClient httpClient;
        long startT;
        block13: {
            if (SdkLogger.isLoggable()) {
                SdkLogger.print("doSyncHttpReq ");
            }
            HttpReturn rret = ret;
            if (ret == null) {
                rret = new HttpReturn();
            }
            startT = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpClient = null;
            httpClient = HttpClientConnManager.HTTP_CLIENT != null ? HttpClientConnManager.HTTP_CLIENT : HttpCaller.createSyncHttpClient(requestURL);
            if (SdkLogger.isLoggable()) {
                SdkLogger.print("--+++ get httpclient costs = " + (System.currentTimeMillis() - startT) + " ms ");
                startT = System.currentTimeMillis();
            }
            try {
                response = httpClient.execute(httpRequestBase);
                rret.httpCode = response.getStatusLine().getStatusCode();
                rret.responseHttpStatus = response.getStatusLine().toString();
                rret.responseHeaders = HttpClientHelper.fetchResHeaders(response);
                rret.respHttpHeaderMap = HttpClientHelper.fetchResHeaderMap(response);
                HttpCaller.fetchResponseBody(response, rret);
                httpReturn = rret;
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        response.close();
                    }
                    if (HttpClientConnManager.HTTP_CLIENT == null) {
                        httpClient.close();
                    }
                    if (SdkLogger.isLoggable()) {
                        SdkLogger.print("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HttpCallerException(e);
                }
            }
            response.close();
        }
        if (HttpClientConnManager.HTTP_CLIENT == null) {
            httpClient.close();
        }
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        return httpReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpReturn doAsyncHttpReq(String requestURL, HttpRequestBase httpRequestBase, HttpReturn ret) throws HttpCallerException {
        HttpReturn httpReturn;
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("doAsyncHttpReq ");
        }
        HttpReturn rret = ret;
        if (ret == null) {
            rret = new HttpReturn();
        }
        long startT = System.currentTimeMillis();
        HttpResponse response = null;
        CloseableHttpAsyncClient httpClient = HttpCaller.createAsyncHttpClient(requestURL);
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("--+++ get httpclient costs = " + (System.currentTimeMillis() - startT) + " ms ");
            startT = System.currentTimeMillis();
        }
        try {
            httpClient.start();
            Future<HttpResponse> asyncFuture = httpClient.execute(httpRequestBase, null);
            long waitTime = HttpCaller.getFutureGetTimeOut();
            if (SdkLogger.isLoggable()) {
                SdkLogger.print("future waitTime :" + waitTime);
            }
            response = waitTime > 0L ? asyncFuture.get(waitTime, TimeUnit.MILLISECONDS) : asyncFuture.get();
            rret.httpCode = response.getStatusLine().getStatusCode();
            rret.responseHttpStatus = response.getStatusLine().toString();
            rret.responseHeaders = HttpClientHelper.fetchResHeaders(response);
            rret.respHttpHeaderMap = HttpClientHelper.fetchResHeaderMap(response);
            HttpCaller.fetchResponseBody(response, rret);
            httpReturn = rret;
        }
        catch (Throwable throwable) {
            try {
                httpClient.close();
                if (SdkLogger.isLoggable()) {
                    SdkLogger.print("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HttpCallerException(e);
            }
        }
        httpClient.close();
        if (SdkLogger.isLoggable()) {
            SdkLogger.print("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        return httpReturn;
    }

    private static void fetchResponseBody(HttpResponse response, HttpReturn rret) throws IOException {
        HttpEntity responseEntity = response.getEntity();
        Header header = responseEntity.getContentType();
        if (header == null) {
            rret.response = EntityUtils.toString(responseEntity, DEFAULT_CHARSET);
            return;
        }
        String contentType = header.getValue();
        if (contentType == null || contentType.equals("")) {
            rret.response = EntityUtils.toString(responseEntity, DEFAULT_CHARSET);
            return;
        }
        if ((contentType = contentType.toLowerCase()).startsWith("text") || contentType.contains("json") || contentType.contains("xml")) {
            rret.response = EntityUtils.toString(responseEntity);
        } else {
            rret.responseBytes = EntityUtils.toByteArray(responseEntity);
        }
    }

    public static String doPost(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, version, paramsMap, accessKey, secretKey, null, null);
    }

    public static String doPost(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey, String signImpl, String verifySignImpl) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).putParamsMapAll(paramsMap).accessKey(accessKey).secretKey(secretKey).signImpl(signImpl).verifySignImpl(verifySignImpl).build();
        return HttpCaller.doPost(hp, null).getResponseStr();
    }

    public static String invoke(HttpParameters hp, Map<String, String> respHttpHeaderMap) throws HttpCallerException {
        HttpReturn res = HttpCaller.invokeReturn(hp);
        if (respHttpHeaderMap != null) {
            respHttpHeaderMap.putAll(res.respHttpHeaderMap);
        }
        return res.getResponseStr();
    }

    public static String invoke(HttpParameters hp, StringBuffer resHttpHeaders) throws HttpCallerException {
        HttpReturn res = HttpCaller.invokeReturn(hp);
        if (resHttpHeaders != null && res.responseHeaders != null) {
            resHttpHeaders.setLength(0);
            resHttpHeaders.append(res.responseHeaders);
        }
        return res.getResponseStr();
    }

    public static HttpReturn invokeReturn(HttpParameters hp) throws HttpCallerException {
        if (hp == null) {
            throw new IllegalArgumentException("null parameter!");
        }
        HttpClientHelper.printDebugInfo("-- httpParameters=" + hp.toString());
        hp.validate();
        HashMap<String, String> extSignHeaders = new HashMap<String, String>();
        if ("POST".equalsIgnoreCase(hp.getMethod()) || "CPOST".equalsIgnoreCase(hp.getMethod())) {
            return HttpCaller.doPost(hp, extSignHeaders);
        }
        return HttpCaller.doGet(hp, extSignHeaders);
    }

    public static String invoke(HttpParameters hp) throws HttpCallerException {
        return HttpCaller.invoke(hp, (StringBuffer)null);
    }

    public static byte[] readFileAsByteArray(String file) throws HttpCallerException {
        return HttpCaller.readFile(new File(file));
    }

    public static byte[] readFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                return HttpCaller.readInputStream(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("bad file to read:" + file);
    }

    public static byte[] readInputStream(InputStream inputStream) {
        if (inputStream != null) {
            ByteArrayOutputStream bos = null;
            try {
                int n;
                bos = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                while ((n = inputStream.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new IllegalArgumentException("inputSteam must no null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoveryFileFromBytes(byte[] body, String filePath, String fileName) throws HttpCallerException {
        try {
            String fileFullPath = filePath;
            fileFullPath = fileFullPath.endsWith("/") ? fileFullPath + fileName : fileFullPath + "/" + fileName;
            File f = new File(fileFullPath);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(body, 0, body.length);
                out.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new HttpCallerException(e);
        }
    }

    public static boolean isAsync() {
        boolean async = false;
        String asyncConf = System.getProperty("http.caller.connection.async");
        if (asyncConf != null && asyncConf.length() > 0) {
            async = Boolean.valueOf(asyncConf);
        }
        return async;
    }

    public static long getFutureGetTimeOut() {
        int connTimeOut;
        int crTimeOut;
        RequestConfig requestConfig = HttpCaller.getRequestConfig();
        long waitTime = 0L;
        int socketTimeOUt = requestConfig.getSocketTimeout();
        if (socketTimeOUt > 0) {
            waitTime += (long)socketTimeOUt;
        }
        if ((crTimeOut = requestConfig.getConnectionRequestTimeout()) > 0) {
            waitTime += (long)crTimeOut;
        }
        if ((connTimeOut = requestConfig.getConnectTimeout()) > 0) {
            waitTime += (long)connTimeOut;
        }
        return (long)((double)waitTime * 1.1);
    }

    private static void log(HttpParameters hp, long startTime, String requestUrl, HttpReturn httpReturn, String msg) {
        long endTime = System.currentTimeMillis();
        Map<String, String> headers = hp.getHeaderParamsMap();
        try {
            int qidx = requestUrl.indexOf("?");
            String url = qidx > -1 ? requestUrl.substring(0, qidx) : requestUrl;
            int cidx = url.indexOf(":");
            int pidx = url.indexOf(":", cidx + 3);
            if (pidx < 0) {
                pidx = url.indexOf("/", cidx + 3);
            }
            String dest = url.substring(cidx + 3, pidx);
            LogUtils.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", startTime, endTime, endTime - startTime, "HTTP", IPUtils.getLocalHostIP(), dest, headers.get(HttpCaller.bizIdKey()), headers.get("_inner_ecsb_request_id"), headers.get("_inner_ecsb_trace_id"), headers.get("_inner_ecsb_rpc_id"), hp.getApi(), hp.getVersion(), HttpCaller.defaultValue(hp.getAccessKey()), hp.getMethod(), url, httpReturn.httpCode, httpReturn.responseHttpStatus, HttpCaller.defaultValue(msg));
        }
        catch (Throwable e) {
            LogUtils.exception(MessageFormat.format("csb invoke error, api:{0}, version:{1}", hp.getApi(), hp.getVersion()), e);
        }
    }

    private static String defaultValue(String val) {
        return val == null ? "" : val.trim();
    }

    public static void main(String[] args) {
        String s = "http://100.100.80.76/api/admin/ServiceRepositoryAPI";
        HttpCaller.log(HttpParameters.newBuilder().build(), System.currentTimeMillis(), s, null, "ss");
    }
}

